<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use DB;

class User extends Authenticatable
{
    use HasFactory, Notifiable;
	
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $keyType      = 'string';
    protected $primaryKey   = 'id_user';
	protected $table = 't_user';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
	
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
	static function daftar($params = array()) {
		$str="  select a.*,b.nama jenis_noidentitasnm,coalesce(a.pekerjaan_lain,c.nama) pekerjaannm, d.nama provinsinm, e.nama kabkotanm,f.nama katpelapornm,
				(case when a.warganegara=1 then 'WNI' else 'WNA' end) warganegaranm,
				(case when a.aktif=1 then 'Aktif' else 'Tidak Aktif' end) aktifnm,
				g.nama stsvalidnm,
				(case when a.id_katpelapor=1 or a.id_katpelapor=2 then h.nama when a.id_katpelapor=3 or a.id_katpelapor=4 then a.kappelapor else '' end) kappelapornm
				from t_user a
				left join m_jenisnoidentitas b on b.id=a.jenis_noidentitas
				left join m_pekerjaan c on c.id=a.pekerjaan
				left join m_provinsi d on d.kode=a.provinsi
				left join m_kabkota e on e.kode=a.kabkota
				left join m_katpelapor f on f.id=a.id_katpelapor
				left join m_kappelapor h on h.id=a.id_kappelapor
				left join m_user g on g.id_user=a.stsvalid_by
				where 1<2 ";
		if(isset($params['id'])){
			$str.=" and a.id_user=".$params['id'];
		}
		if(isset($params['aktif'])){
			$str.=" and a.aktif=".$params['aktif'];
        }
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				//$this->db->where("(substr(a.wilayah,1,2)='".substr($locus,0,2)."' or a.locus_daftar='".$locus."')", null, false);
				$str.=" and (substr(a.wilayah,1,2)='".substr($locus,0,2)."' or a.locus_daftar='".$locus."') ";
			}
			else{
				//$this->db->where("(a.wilayah='".$locus."' or a.locus_daftar='".$locus."')", null, false);
				$str.=" and (a.wilayah='".$locus."' or a.locus_daftar='".$locus."') ";
			}
        }
		if (isset($params['provinsi'])){
			$str.=" and a.provinsi=".$params['provinsi'];
		}
		if (isset($params['kabkota'])){
			$str.=" and a.kabkota=".$params['kabkota'];
		}
		//echo $str;
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function cekadd($data = array()){
		$res=User::whereRaw('1=1');
		if(isset($data['nm_user'])){
			$res=$res->where('nm_user','=','nm_user');
		}
		if(isset($data['no_identitas'])){
			$res=$res->where('no_identitas','=','no_identitas');
		}
		$res=$res->first();
		return $res;
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=User::where('id_user','=',$data['id'])->first();
			if (isset($data['nama'])) {
	            $res->nama=getinpa($data['nama']);
	        }
			if (isset($data['nm_user'])) {
	            $res->nm_user=getinpa($data['nm_user']);
	        }
			if (isset($data['sandi'])) {
	            $res->sandi=sha1(getinpa($data['sandi']));
	        }
			if (isset($data['aktif'])) {
	            $res->aktif=getinpa($data['aktif']);
	        }
			if (isset($data['foto_diri'])) {
	            $res->foto_diri=getinpa($data['foto_diri']);
	        }
			if (isset($data['foto_identitas'])) {
	            $res->foto_identitas=getinpa($data['foto_identitas']);
	        }
			if (isset($data['jenis_noidentitas'])) {
	            $res->jenis_noidentitas=getinpa($data['jenis_noidentitas']);
	        }
			if (isset($data['jenis_kelamin'])) {
	            $res->jenis_kelamin=getinpa($data['jenis_kelamin']);
	        }
			if (isset($data['no_identitas'])) {
	            $res->no_identitas=getinpa($data['no_identitas']);
	        }
			if (isset($data['id_katpelapor'])) {
	            $res->id_katpelapor=getinpa($data['id_katpelapor']);
	        }
			if (isset($data['id_kappelapor'])) {
	            $res->id_kappelapor=getinpa($data['id_kappelapor']);
	        }
			if (isset($data['kappelapor'])) {
	            $res->kappelapor=getinpa($data['kappelapor']);
	        }
			if (isset($data['tempat_lahir'])) {
	            $res->tempat_lahir=getinpa($data['tempat_lahir']);
	        }
			if (isset($data['tanggal_lahir'])) {
	            $res->tanggal_lahir=InggrisTgl(getinpa($data['tanggal_lahir']));
	        }
			if (isset($data['pekerjaan'])) {
	            $res->pekerjaan=getinpa($data['pekerjaan']);
	        }
			if (isset($data['pekerjaan_lain'])) {
	            $res->pekerjaan_lain=getinpa($data['pekerjaan_lain']);
	        }
			if (isset($data['jabatan'])) {
	            $res->jabatan=getinpa($data['jabatan']);
	        }
			if (isset($data['warganegara'])) {
	            $res->warganegara=getinpa($data['warganegara']);
	        }
			if (isset($data['alamat'])) {
	            $res->alamat=getinpa($data['alamat']);
	        }
			if (isset($data['provinsi'])) {
	            $res->provinsi=getinpa($data['provinsi']);
	        }
			if (isset($data['kabkota'])) {
	            $res->kabkota=getinpa($data['kabkota']);
	        }
			if (isset($data['wilayah'])) {
	            $res->wilayah=getinpa($data['wilayah']);
	        }
			if (isset($data['hp'])) {
	            $res->hp=getinpa($data['hp']);
	        }
			if (isset($data['fax'])) {
	            $res->fax=getinpa($data['fax']);
	        }
			if (isset($data['email'])) {
	            $res->email=getinpa($data['email']);
	        }
			if (isset($data['stsvalid_by'])) {
	            $res->stsvalid_by=getinpa($data['stsvalid_by']);
	        }
			if (isset($data['stsvalid_date'])) {
	            $res->stsvalid_date=getinpa($data['stsvalid_date']);
	        }
			if (isset($data['locus_daftar'])) {
	            $res->locus_daftar=getinpa($data['locus_daftar']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new User;
			if (isset($data['nama'])) {
	            $res->nama=getinpa($data['nama']);
	        }
			if (isset($data['nm_user'])) {
	            $res->nm_user=getinpa($data['nm_user']);
	        }
			if (isset($data['sandi'])) {
	            $res->sandi=sha1(getinpa($data['sandi']));
	        }
			if (isset($data['aktif'])) {
	            $res->aktif=getinpa($data['aktif']);
	        }
			if (isset($data['foto_diri'])) {
	            $res->foto_diri=getinpa($data['foto_diri']);
	        }
			if (isset($data['foto_identitas'])) {
	            $res->foto_identitas=getinpa($data['foto_identitas']);
	        }
			if (isset($data['jenis_noidentitas'])) {
	            $res->jenis_noidentitas=getinpa($data['jenis_noidentitas']);
	        }
			if (isset($data['jenis_kelamin'])) {
	            $res->jenis_kelamin=getinpa($data['jenis_kelamin']);
	        }
			if (isset($data['no_identitas'])) {
	            $res->no_identitas=getinpa($data['no_identitas']);
	        }
			if (isset($data['id_katpelapor'])) {
	            $res->id_katpelapor=getinpa($data['id_katpelapor']);
	        }
			if (isset($data['id_kappelapor'])) {
	            $res->id_kappelapor=getinpa($data['id_kappelapor']);
	        }
			if (isset($data['kappelapor'])) {
	            $res->kappelapor=getinpa($data['kappelapor']);
	        }
			if (isset($data['tempat_lahir'])) {
	            $res->tempat_lahir=getinpa($data['tempat_lahir']);
	        }
			if (isset($data['tanggal_lahir'])) {
	            $res->tanggal_lahir=InggrisTgl(getinpa($data['tanggal_lahir']));
	        }
			if (isset($data['pekerjaan'])) {
	            $res->pekerjaan=getinpa($data['pekerjaan']);
	        }
			if (isset($data['pekerjaan_lain'])) {
	            $res->pekerjaan_lain=getinpa($data['pekerjaan_lain']);
	        }
			if (isset($data['jabatan'])) {
	            $res->jabatan=getinpa($data['jabatan']);
	        }
			if (isset($data['warganegara'])) {
	            $res->warganegara=getinpa($data['warganegara']);
	        }
			if (isset($data['alamat'])) {
	            $res->alamat=getinpa($data['alamat']);
	        }
			if (isset($data['provinsi'])) {
	            $res->provinsi=getinpa($data['provinsi']);
	        }
			if (isset($data['kabkota'])) {
	            $res->kabkota=getinpa($data['kabkota']);
	        }
			if (isset($data['wilayah'])) {
	            $res->wilayah=getinpa($data['wilayah']);
	        }
			if (isset($data['hp'])) {
	            $res->hp=getinpa($data['hp']);
	        }
			if (isset($data['fax'])) {
	            $res->fax=getinpa($data['fax']);
	        }
			if (isset($data['email'])) {
	            $res->email=getinpa($data['email']);
	        }
			if (isset($data['stsvalid_by'])) {
	            $res->stsvalid_by=getinpa($data['stsvalid_by']);
	        }
			if (isset($data['stsvalid_date'])) {
	            $res->stsvalid_date=getinpa($data['stsvalid_date']);
	        }
			if (isset($data['locus_daftar'])) {
	            $res->locus_daftar=getinpa($data['locus_daftar']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function del($id){
		User::where('id_user',$id)->delete();
    }
}
