<?php
namespace App\Models;
use DB;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Model;

class Nomor extends Model
{
	static function getnourutreg($m, $id_laporan) {
		$s='';
		$urut=0;
		if($m!=''){
			$arr=explode('/',$m);
			$locus=$arr[4];
			$kecamatan_kota = $arr[3];
			$bulantahun=self::getkodebulantahun($id_laporan);
			$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
			$t_locus=DB::table('t_laporan')->select('locus')->where('id','=',$id_laporan)->orderBy('id', 'asc')->first()->locus;
			if (substr($kecamatan_kota, 0, 4) == 'Kec-') {
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw('kejadiannegara IS NULL')->whereRaw("substr(no_registrasi,9,2)='".$arr[1]."'")->whereRaw("substr(no_registrasi,12,2)='".$arr[2]."'")->where("locus","=",$t_locus)->first()->urut;
			} else {    
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw('kejadiannegara IS NULL')->whereRaw("substr(no_registrasi,9,2)='".$arr[1]."'")->whereRaw("substr(no_registrasi,12,2)='".$arr[2]."'")->where("locus","=",$t_locus)->first()->urut;
			}
			if(!is_null($nourut)){
				$nourut=$nourut+1;
				$urut=$nourut;
			}
			else{
				$urut=$urut+1;
			}
			$s=str_repeat('0',3-strlen($urut)).$urut.'/Reg/'.$arr[1].'/'.$arr[2].'/'.$arr[3].'/'.$arr[4].'/'.$bulantahun;
		}
		return $s;
	}
	static function getnourutreg2($m, $id_laporan){
		$s='';
		$urut=0;
		if($m!=''){
			$arr=explode('/',$m);
			$locus=$arr[4];
			$bulantahun=self::getkodebulantahun($id_laporan);
			$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
			$t_locus=DB::table('t_laporan')->select('locus')->where('id','=',$id_laporan)->orderBy('id', 'asc')->first()->locus;
			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi2,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw('kejadiannegara IS NULL')->whereRaw("substr(no_registrasi2,5,2)='".$arr[1]."'")->whereRaw("substr(no_registrasi2,12,2)='".$arr[2]."'")->where("locus","=",$t_locus)->first()->urut;
			if(!is_null($nourut)){
				$nourut=$nourut+1;
				$urut=$nourut;
			}
			else{
				$urut=$urut+1;
			}
			$s=str_repeat('0',3-strlen($urut)).$urut.'/'.$arr[1].'/ADM.'.$arr[2].'/BWSL.'.$arr[3].'/'.$arr[4].'/'.$bulantahun;
		}
		return $s;
	}
	static function getnourutregpelimpahan($m,$locus, $id_laporan){
		$s='';
		$urut=0;
		if($m!=''){
			$arr=explode('/',$m);
			$bulantahun=self::getkodebulantahun($id_laporan);
			$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
			$res=DB::table('t_laporan')->select('jenistempatkejadian','kejadiannegara')->where('id','=',$id_laporan)->orderBy('id', 'desc')->first();
			if ($res->jenistempatkejadian=='Dalam Negeri') {
    			$kodepengawas=self::getkodepengawas($res->jenistempatkejadian,$locus);
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi,1,3),signed)) urut')->where('id_periode','=',$periode)->where("locus","=",$locus)->whereRaw("coalesce(kecamatan,'')=''")->first()->urut;
				if(!is_null($nourut)){
    				$nourut=$nourut+1;
    				$urut=$nourut;
    			}
    			else{
    				$urut=$urut+1;
    			}
			    $s=str_repeat('0',3-strlen($urut)).$urut.'/Reg/'.$arr[1].'/'.$arr[2].'/'.$kodepengawas.'/'.$bulantahun;
			} else if ($res->jenistempatkejadian=='Luar Negeri') {
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw("substr(no_registrasi,9,2)='".$arr[1]."'")->whereRaw("substr(no_registrasi,12,2)='".$arr[2]."'")->where("kejadiannegara","=",$res->kejadiannegara)->first()->urut;
				if(!is_null($nourut)){
    				$nourut=$nourut+1;
    				$urut=$nourut;
    			}
    			else{
    				$urut=$urut+1;
    			}
				$negara=DB::table("m_negara")->select('negara')->whereRaw("TRIM(nama)='".$res->kejadiannegara."'")->first()->negara;
			    $s=str_repeat('0',3-strlen($urut)).$urut.'/Reg/'.$arr[1].'/'.$arr[2].'/PLN-'.$res->kejadiannegara.'/'.$negara.'/'.$bulantahun;
			}
		}
		return $s;
	}
	static function getnourutregpelimpahan2($m,$locus, $id_laporan){
		$s='';
		$urut=0;
		if($m!=''){
			$arr=explode('/',$m);
			$bulantahun=self::getkodebulantahun($id_laporan);
			$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
			$res=DB::table('t_laporan')->select('jenistempatkejadian','kejadiannegara')->where('id','=',$id_laporan)->orderBy('id', 'desc')->first();
			if ($res->jenistempatkejadian=='Dalam Negeri') {
    			$kodepengawas=self::getkodepengawas($res->jenistempatkejadian,$locus);
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi2,1,3),signed)) urut')->where('id_periode','=',$periode)->where("locus","=",$locus)->whereRaw("coalesce(kecamatan,'')=''")->first()->urut;
				if(!is_null($nourut)){
    				$nourut=$nourut+1;
    				$urut=$nourut;
    			}
    			else{
    				$urut=$urut+1;
    			}
			    $s=str_repeat('0',3-strlen($urut)).$urut.'/Reg/'.$arr[1].'/'.$arr[2].'/'.$kodepengawas.'/'.$bulantahun;
			} else if ($res['jenistempatkejadian']=='Luar Negeri') {
    			$nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no_registrasi2,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw("substr(no_registrasi2,9,2)='".$arr[1]."'")->whereRaw("substr(no_registrasi2,16,2)='".$arr[2]."'")->where("kejadiannegara","=",$res->kejadiannegara)->first()->urut;
				if(!is_null($nourut)){
    				$nourut=$nourut+1;
    				$urut=$nourut;
    			}
    			else{
    				$urut=$urut+1;
    			}
			    $negara=DB::table("m_negara")->select('negara')->whereRaw("TRIM(nama)='".$res->kejadiannegara."'")->first()->negara;
			    $s=str_repeat('0',3-strlen($urut)).$urut.'/Reg/'.$arr[1].'/ADM.'.$arr[2].'/PLN-'.$res['kejadiannegara'].'/'.$negara.'/'.$bulantahun;
			}
		}
		return $s;
	}
	static function getkodebulantahun($id_laporan,$tgl_offline=null){
		$s='';
		if ($id_laporan == 0) {
		    $tgl_offline=getinp($tgl_offline);
		    if ($tgl_offline ==''|| empty($tgl_offline)) {
    		    $bln=date('m');
    		    $thn=date('Y');
		    } else {
		        $tgl_offline=explode('/',$tgl_offline);
           		$tgl_offline=$tgl_offline[2].'-'.$tgl_offline[1].'-'.$tgl_offline[0].' 01:01:01';
				/*
				$res=DB::table("t_laporan")->where('id', "=", $id_laporan)->first();
				$res->tgl_offline=strtotime($tgl_offline);
				$res->save();
				*/
				
           		$bln=date('m', strtotime($tgl_offline));
           		$thn=date('Y', strtotime($tgl_offline));
		    }
		} else {
    		$tgl_registrasi=DB::table('t_laporan')->select('tgl_registrasi')->where('id','=',$id_laporan)->first()->tgl_registrasi;
    		if ($tgl_registrasi) {
        		$bln=date('m', strtotime($tgl_registrasi));
        		$thn=date('Y', strtotime($tgl_registrasi));
    		} else {
        		$tgl_registrasi=getinp($_POST['tgl_registrasi']);
        		if ($tgl_registrasi!='') {
            		$tgl_registrasi=explode('/',$tgl_registrasi);
            		$tgl_registrasi=$tgl_registrasi[2].'-'.$tgl_registrasi[1].'-'.$tgl_registrasi[0].' 01:01:01';
					$res=DB::table("t_laporan")->where('id', "=", $id_laporan)->first();
					$res->tgl_registrasi=strtotime($tgl_registrasi);
					$res->save();
					
            		$bln=date('m', strtotime($tgl_registrasi));
            		$thn=date('Y', strtotime($tgl_registrasi));
        		} else {
            		$bln=date('m');
            		$thn=date('Y');
        		}
    		}
	    }
		if($bln==1){
			$s='I';
		}
		elseif($bln==2){
			$s='II';
		}
		elseif($bln==3){
			$s='III';
		}
		elseif($bln==4){
			$s='IV';
		}
		elseif($bln==5){
			$s='V';
		}
		elseif($bln==6){
			$s='VI';
		}
		elseif($bln==7){
			$s='VII';
		}
		elseif($bln==8){
			$s='VIII';
		}
		elseif($bln==9){
			$s='IX';
		}
		elseif($bln==10){
			$s='X';
		}
		elseif($bln==11){
			$s='XI';
		}
		elseif($bln==12){
			$s='XII';
		}
		$s.='/'.$thn;
		return $s;
	}
	static function getkodepengawas($a,$b,$kejadiannegara=null){
		$s='';
		$jenistempatkejadian=$a;
		$locus=$b;
		if($jenistempatkejadian=="Dalam Negeri"){
			if($locus=='0'){
				$s='RI/00.00';
			}
			elseif(substr($locus,3,2)=='00'){
				$nm=DB::table("m_provinsi")->select('nama')->where('kode',"=",$locus)->first()->nama;
				$s='Prov/'.$locus;
			}
			else{
				$nmkota=DB::table("m_kabkota")->select('nama')->where('kode',"=",$locus)->first()->nama;
				if(is_numeric(strpos(strtolower($nmkota),'kota'))){
					$s='Kota/'.$locus;
				}
				else{
					$s='Kab/'.$locus;
				}
			}
		}
		else{
			$kodenegara=getinp($kejadiannegara);
			$negara=DB::table("m_negara")->select('negara')->whereRaw("TRIM(nama)='".$kodenegara."'")->first()->negara; 
		    $s='PLN-'.$kodenegara.'/'.$negara;
		}
		return $s;
	}
	static function getjenispemilu($a){
		$s='';
		$id_jenispemilihan=$a;
		if($id_jenispemilihan==5||$id_jenispemilihan==6||$id_jenispemilihan==7||$id_jenispemilihan==8||$id_jenispemilihan==9||$id_jenispemilihan==10||$id_jenispemilihan==11||$id_jenispemilihan==12||$id_jenispemilihan==13){
			$s='PL';
		}
		elseif($id_jenispemilihan==4){
			$s='PP';
		}
		elseif($id_jenispemilihan==1){
			$s='PG';
		}
		elseif($id_jenispemilihan==3){
			$s='PW';
		}
		elseif($id_jenispemilihan==2){
			$s='PB';
		}
		return $s;
	}
	static function getnourut($kecamatan, $m, $lp, $pp){
		$s='';
		$urut=0;
		if($m!=''){
			$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
			if ($kecamatan != '') {
			    $nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw("kejadiannegara IS NULL")->whereRaw("substr(no,5,2)='".$lp."'")->whereRaw("substr(no,8,2)='".$pp."'")->whereRaw("substr(no,15,".strlen($kecamatan).")='".$kecamatan."'")->first()->urut;
			} else {
			    $nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw("kejadiannegara IS NULL")->whereRaw("substr(no,5,2)='".$lp."'")->whereRaw("substr(no,8,2)='".$pp."'")->where('locus','=',$m)->first()->urut;
			}
			if($nourut){
				$nourut++;
				$urut=$nourut;
			}
			else{
				$urut++;
			}
			$s=str_repeat('0',3-strlen($urut)).$urut;
		}
		return $s;
	}
	static function getnourutluarnegeri($kejadiannegara, $lp, $pp) {
	    $urut = 0;
		$periode=DB::table('m_periode')->select('id')->where('aktif','=',1)->limit(1)->orderBy('id', 'asc')->first()->id;
	    $nourut = DB::table("t_laporan")->selectRaw('max(convert(substr(no,1,3),signed)) urut')->where('id_periode','=',$periode)->whereRaw("substr(no,5,2)='".$lp."'")->whereRaw("substr(no,8,2)='".$pp."'")->where('kejadiannegara','=',$kejadiannegara)->first()->urut;
		if(!is_null($nourut)){
			$nourut=$nourut+1;
			$urut=$nourut;
		}
		else{
			$urut=$urut+1;
		}
	    return str_repeat('0',3-strlen($urut)).$urut;
	}
}
