<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use DB;

class M_undangan extends Model
{
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_undangan';
    protected $fillable = [
	'id_laporan',
	'note',
	'dokumen',
	'stsbaca',
	'tanggal_baca',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date'
	];
	
	static function daftar($params = array()){
		$str="select a.*, b.stsposisi, b.locus,b.id_jenislaporan, b.no, c.nama pelapornm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_undangan a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$str.=" and b.locus=".$params['locus'];
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['id_pelapor'])){
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_index($params = array()){
		$str="select a.*, b.stsposisi, b.locus,b.no,b.id_jenislaporan, c.nama pelapornm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_undangan a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				$str.=" and substr(b.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$str.=" and b.locus='".$locus."'";
			}
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['id_pelapor'])){
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_depan($params = array()){
		$res=DB::table("t_undangan as a")->selectRaw("a.*, b.stsposisi, b.no,b.id_jenislaporan, c.nama pelapornm")
			 ->join("t_laporan as b","b.id","=","a.id_laporan")
			 ->join("t_user as c","c.id_user","=","b.id_pelapor");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['locus'])) {
			$res=$res->where('b.locus',$params['locus']);
		}
		if (isset($params['id_jenislaporan'])) {
			if($params['id_jenislaporan']==1){
				$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
			}
			elseif($params['id_jenislaporan']==2||$params['id_jenislaporan']==3){
				$res=$res->whereRaw(' (b.id_jenislaporan=2 or b.id_jenislaporan=3) ');
			}
		}
		if (isset($params['id_pelapor'])){
			$res=$res->where('b.id_pelapor', $params['id_pelapor']);
		}
		if (isset($params['cari'])){
			$res=$res->whereRaw("(lower(b.no) like '%".$params['cari']."%' or lower(a.note) like '%".$params['cari']."%') ");
		}
		$res=$res->orderBy("id", "desc");
		if (isset($params['start'])){
			$res=$res->limit($params['per_page'],$params['start']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
	}
	static function getlaporan($params = array()){
		$res=DB::table("t_undangan as a")->selectRaw("b.no, b.no_registrasi, b.id_jenislaporan")
		     ->join("t_laporan b","b.id","=","a.id_laporan");
		if (isset($params['id'])) {
            $res=$res->where('a.id', $params['id']);
        }
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_undangan::where('id','=',$data['id'])->first();
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['stsbaca'])) {
	            $res->stsbaca=getinpa($data['stsbaca']);
	        }
			if (isset($data['tanggal_baca'])) {
	            $res->tanggal_baca=getinpa($data['tanggal_baca']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_undangan;
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['stsbaca'])) {
	            $res->stsbaca=getinpa($data['stsbaca']);
	        }
			if (isset($data['tanggal_baca'])) {
	            $res->tanggal_baca=getinpa($data['tanggal_baca']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	function del($id) {
        M_undangan::where('id', $id)->delete();
    }
}
