<?php
namespace App\Models;

use App\Models\M_sidang_proses;
use App\Models\M_sidang_berkas;
use App\Models\M_sidang_prosesfile;
use App\Models\M_sidang_putusan;
use App\Models\M_sidang_risalah;
use Illuminate\Database\Eloquent\Model;
use DB;

class M_sidang extends Model
{
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_sidang';
    protected $fillable = [
	'id_laporan',
	'kuasa_hukum',
	'tanggal',
	'proses',
	'keterangan',
	'id_proses',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date',
	];
	
	static function daftar($params = array()){
		$str="select a.*, b.stsposisi,b.no_registrasi, b.locus, b.no, b.id_jenislaporan, c.nama pelapornm, b.ringkasan,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_sidang a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['id_pelapor'])){
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
		}
		if (isset($params['locus'])) {
			$str.=" and b.locus='".$params['locus']."'";
        }
		if (isset($params['tanggal'])) {
			$str.=" and date_format(a.tanggal,'%Y-%m-%d')='".$params['tanggal']."'";
        }
		if (isset($params['tahunbulan'])) {
			$str.=" and date_format(a.tanggal,'%Y-%m')='".$params['tahunbulan']."'";
        }
		$str.=" and b.id_jenislaporan=2";
		if (isset($params['cari'])){
			$str.=" and (lower(b.no) like '%".$params['cari']."%' or lower(c.nama) like '%".$params['cari']."%' or lower(a.kuasa_hukum) like '%".$params['cari']."%' or lower(a.proses) like '%".$params['cari']."%' or lower(a.keterangan) like '%".$params['cari']."%' or lower(sf_formatTanggal(tanggal)) like '%".strtolower($params['cari'])."%') ";
		}
		$str.=" order by a.id desc ";
		if (isset($params['start'])){
			$str.=" limit ".$params['per_page'].",".$params['start'];
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_index($params = array()){
		$str="select a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm, b.ringkasan,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_sidang a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['tanggal'])){
			$str.=" and date_format(a.tanggal,'%Y-%m-%d')='".$params['tanggal']>"'";
		}
		$str.=" and b.id_jenislaporan=2";
		if (isset($params['locus'])){
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				$str.=" and substr(b.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$str.=" and b.locus='".$locus."'";
			}
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	
	static function getlaporan($params = array()) {
		$res=DB::table("t_sidang as a")
			 ->join('t_laporan as b','b.id','=','a.id_laporan')
			 ->selectRaw("b.no, b.stsposisi,b.locus, b.id_jenislaporan, b.no_registrasi");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_proses($params = array()){
		$res=DB::table("t_sidang_proses as a")
			->leftJoin('m_user as b','b.id_user','=','a.create_by')
			->leftJoin('m_sidang_step as c','c.id','=','a.id_step')
			->selectRaw("a.*, b.nama,c.nama stepnm");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidang'])){
			$res=$res->where('a.id_sidang', $params['id_sidang']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_berkas($params = array()) {
		$res=DB::table("t_sidang_berkas as a")
			->selectRaw("a.*");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidang'])){
			$res=$res->where('a.id_sidang', $params['id_sidang']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_putusan($params = array()) {
		$res=DB::table("t_sidang_putusan as a")
			->selectRaw("a.*");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidang'])){
			$res=$res->where('a.id_sidang', $params['id_sidang']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_risalah($params = array()) {
		$res=DB::table("t_sidang_risalah as a")
			->selectRaw("a.*");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidang'])){
			$res=$res->where('a.id_sidang', $params['id_sidang']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_prosesurutstep($params = array()) {
		$res=DB::table("t_sidang_proses as a")
			->leftJoin('m_user as b','b.id_user','=','a.create_by')
			->leftJoin('m_sidang_step as c','c.id','=','a.id_step')
			->selectRaw("a.*, b.nama,c.nama stepnm");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidang'])){
			$res=$res->where('a.id_sidang', $params['id_sidang']);
		}
		$res=$res->orderBy("harike", "asc");
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_dokumen($params = array()) {
		$res=DB::table("t_sidang_prosesfile as a")
			->leftJoin('m_user as b','b.id_user','=','a.create_by')
			->selectRaw("a.*, b.nama");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_sidangproses'])){
			$res=$res->where('a.id_sidangproses', $params['id_sidangproses']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang::where('id','=',$data['id'])->first();
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['kuasa_hukum'])) {
	            $res->kuasa_hukum=getinpa($data['kuasa_hukum']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=getinpb($data['tanggal']);
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['id_proses'])) {
	            $res->id_proses=getinpa($data['id_proses']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang;
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['kuasa_hukum'])) {
	            $res->kuasa_hukum=getinpa($data['kuasa_hukum']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=getinpb($data['tanggal']);
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['id_proses'])) {
	            $res->id_proses=getinpa($data['id_proses']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_proses($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang_proses::where('id','=',$data['id'])->first();
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['id_step'])) {
	            $res->id_step=getinpa($data['id_step']);
	        }
			if (isset($data['harike'])) {
	            $res->harike=getinpa($data['harike']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=InggrisTglTime(getinpa($data['tanggal']));
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang_proses;
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['id_step'])) {
	            $res->id_step=getinpa($data['id_step']);
	        }
			if (isset($data['harike'])) {
	            $res->harike=getinpa($data['harike']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=InggrisTglTime(getinpa($data['tanggal']));
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_berkas($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang_berkas::where('id','=',$data['id'])->first();
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['diserahkan'])) {
	            $res->diserahkan=getinpa($data['diserahkan']);
	        }
			if (isset($data['banyak'])) {
	            $res->banyak=getinpa($data['banyak']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['pihak'])) {
	            $res->pihak=getinpa($data['pihak']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang_berkas;
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['diserahkan'])) {
	            $res->diserahkan=getinpa($data['diserahkan']);
	        }
			if (isset($data['banyak'])) {
	            $res->banyak=getinpa($data['banyak']);
	        }
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['pihak'])) {
	            $res->pihak=getinpa($data['pihak']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_putusan($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang_putusan::where('id','=',$data['id'])->first();
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['deskripsi'])) {
	            $res->deskripsi=getinpa($data['deskripsi']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang_putusan;
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['deskripsi'])) {
	            $res->deskripsi=getinpa($data['deskripsi']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_risalah($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang_risalah::where('id','=',$data['id'])->first();
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=InggrisTglTime(getinpa($data['tanggal']));
	        }
			if (isset($data['file_pdf'])) {
	            $res->file_pdf=getinpa($data['file_pdf']);
	        }
			if (isset($data['file_audio'])) {
	            $res->file_audio=getinpa($data['file_audio']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang_risalah;
			if (isset($data['id_sidang'])) {
	            $res->id_sidang=getinpa($data['id_sidang']);
	        }
			if (isset($data['proses'])) {
	            $res->proses=getinpa($data['proses']);
	        }
			if (isset($data['tanggal'])) {
	            $res->tanggal=InggrisTglTime(getinpa($data['tanggal']));
	        }
			if (isset($data['file_pdf'])) {
	            $res->file_pdf=getinpa($data['file_pdf']);
	        }
			if (isset($data['file_audio'])) {
	            $res->file_audio=getinpa($data['file_audio']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_dokumen($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_sidang_prosesfile::where('id','=',$data['id'])->first();
			if (isset($data['id_sidangproses'])) {
	            $res->id_sidangproses=getinpa($data['id_sidangproses']);
	        }
			if (isset($data['deskripsi'])) {
	            $res->deskripsi=getinpa($data['deskripsi']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_sidang_prosesfile;
			if (isset($data['id_sidangproses'])) {
	            $res->id_sidangproses=getinpa($data['id_sidangproses']);
	        }
			if (isset($data['deskripsi'])) {
	            $res->deskripsi=getinpa($data['deskripsi']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function del($id) {
		M_sidang_risalah::where('id_sidang', $id)->delete();
		M_sidang_putusan::where('id_sidang', $id)->delete();
		M_sidang_berkas::where('id_sidang', $id)->delete();
        DB::select('delete from t_sidang_prosesfile where id_sidangproses in(select id from t_sidang_proses where id_sidang='.$id.')');
		M_sidang_proses::where('id_sidang', $id)->delete();
		M_sidang::where('id', $id)->delete();
    }
	static function del_proses($id) {
		M_sidang_prosesfile::where('id_sidangproses', $id)->delete();
		M_sidang_proses::where('id', $id)->delete();
    }
	static function del_berkas($id) {
		M_sidang_berkas::where('id', $id)->delete();
    }
	static function del_putusan($id) {
		M_sidang_putusan::where('id', $id)->delete();
    }
	static function del_risalah($id) {
		M_sidang_risalah::where('id', $id)->delete();
    }
	static function del_dokumen($id) {
		M_sidang_prosesfile::where('id', $id)->delete();
    }
}
