<?php
namespace App\Models;

use DB;
use Illuminate\Database\Eloquent\Model;

class M_rekapa extends Model
{
	static function daftar($params = array()) {
		$sql="select a.id,a.no,a.no_offline,n.admbano,a.create_date, n1.nama kajianawal_kategorinm,
			(case when a.stslap=2 then (case when n.id_kat1=9 then 'Tidak diregistrasi karena dicabut' else 'Tidak diregistrasi karena tidak memenuhi formil/materil' end) 
			when a.stslap=1 then 'Registrasi' else 'Belum registrasi' end) statuslaporan, 
			(case when substring(a.locus,1,2)='00' then 'Bawaslu RI' else b.nama end) provinsi,
			(case when substring(a.locus,1,2)='00' then '' else c.nama end) kabkota,
			d.nama daerah_pemilihan,
			(case when substr(a.no,6,2)='LP' then 'Laporan' else 'Temuan' end) lptm,
			e.nama tahapan,a.no_registrasi,a.waktukejadian,
			f.nama pelapor_nm,f.hp pelapor_hp, f.jabatan pelapor_jabatan, f.tanggal_lahir pelapor_tanggallahir,
			f.jenis_kelamin pelapor_jeniskelamin,
			g.nama terlapor_nama, g.hp terlapor_hp, h.terlapor,
			i.nama saksi_nama, i.hp saksi_hp, j.saksi,
			a.waktudiketahui,a.ringkasan,
			l.nama hasilkajian, m.pelanggaran,
			a1.nama pelanggaran_kajianawal,
			a2.nama trendpelanggaran_kajianawal,
			q.nama trendpelanggaran_kajianakhir,
			(case when r.id_status=1 then 'Tindak Lanjut' when r.id_status=0 then 'Tidak Tindak Lanjut' else '' end) status_tindaklanjut,
			s.statusnm status_tindaklanjut_tahapan
			from t_laporan a
			left join m_provinsi b on substr(a.locus,1,2)=substr(b.kode,1,2)
			left join m_kabkota c on c.kode=a.locus
			left join m_jenispemilihan d on d.id=a.id_jenispemilihan
			left join m_tahapan e on e.id=a.id_tahapan
			left join t_user f on f.id_user=a.id_pelapor
			left join (select id_laporan,nama,hp
			from t_terlapor where urut=1) g on g.id_laporan=a.id
			left join (select id_laporan, 
			group_concat(nama separator ', ') terlapor
			from t_terlapor where urut>1
			group by id_laporan) h on h.id_laporan=a.id
			left join (select id_laporan,nama,hp
			from t_saksi where urut=1) i on i.id_laporan=a.id
			left join (select id_laporan, 
			group_concat(nama separator ', ') saksi
			from t_saksi where urut>1
			group by id_laporan) j on j.id_laporan=a.id
			left join t_status k on k.id_laporan=a.id
			left join m_status_kategori l on l.id=k.id_kat1
			left join (
			select aa.id_laporan, 
			group_concat(cc.nama separator ',') pelanggaran
			from t_kajianakhir aa
			left join t_kajianakhir_kategori bb on aa.id=bb.id_kajianakhir
			left join m_kajianakhir_kategori cc on cc.id=bb.id_kat1
			group by aa.id_laporan
			) m on m.id_laporan=a.id
			left join t_kajianawal n on n.id_laporan=a.id
			left join m_kajianawal_kategori n1 on n1.id=n.id_kat1
      		left join (select id_kajianawal, 
			group_concat(b.nama separator ', ') nama
			from t_kajianawal_pelanggaran a, m_kajianawala_kategori b where a.id_pelanggaran=b.id
			group by id_kajianawal) a1 on a1.id_kajianawal=n.id
      		left join (select id_kajianawal, 
			group_concat(b.nama separator ', ') nama
			from t_kajianawal_pelanggaran a, m_trendpelanggaran b where a.id_trend=b.id
			group by id_kajianawal) a2 on a2.id_kajianawal=n.id
			left join m_trendpelanggaran o on o.id=n.id_trendpelanggaran
			left join t_kajianakhir p on p.id_laporan=a.id
			left join m_trendpelanggaran q on q.id=p.id_trendpelanggaran 
			left join t_tindaklanjut r on r.id_laporan=a.id
			left join (
			select id_laporan, 
			group_concat(a3.nama separator ', ') statusnm
			from t_tindaklanjut_kategori a1
			inner join t_tindaklanjut a2 on a1.id_tindaklanjut=a2.id
			inner join m_tindaklanjut_status a3 on a3.id=a1.id_status
			group by id_laporan) s on s.id_laporan=a.id
			where a.id_jenislaporan = 1 ";
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
            	$sql.=" and substr(a.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$sql.=" and a.locus='".$locus."'";
			}
        }
		$sql.=' order by a.id desc';
		$res=DB::select($sql);
        return $res;
	}
}
