<?php
namespace App\Models;

use App\Models\M_putusan_dokumen;
use Illuminate\Database\Eloquent\Model;
use DB;

class M_putusan extends Model
{
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_putusan';
    protected $fillable = [
	'id_laporan',
	'note',
	'dokumen',
	'id_kat1',
	'id_kat2',
	'id_kat3',
	'rekomendasi_no',
	'rekomendasi_file',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date',
	];
	
	static function daftar($params = array()){
		$str="select a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm, d.nama kat1nm, e.nama kat2nm, f.nama kat3nm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_putusan a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_kajianakhir_kategori d on d.id=a.id_kat1
		left join m_kajianakhir_kategori e on e.id=a.id_kat2
		left join m_kajianakhir_kategori f on f.id=a.id_kat3
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])) {
			$str.=" and b.locus='".$params['locus']."'";
        }
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_index($params = array()){
		$str="select a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm, d.nama kat1nm, e.nama kat2nm, f.nama kat3nm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_putusan a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_kajianakhir_kategori d on d.id=a.id_kat1
		left join m_kajianakhir_kategori e on e.id=a.id_kat2
		left join m_kajianakhir_kategori f on f.id=a.id_kat3
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['locus'])){
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				$str.=" and substr(b.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$str.=" and b.locus='".$locus."'";
			}
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function getlaporan($params = array()) {
		$res=DB::table("t_putusan as a")
			 ->join('t_laporan as b','b.id','=','a.id_laporan')
			 ->selectRaw("b.no, b.stsposisi,b.locus, b.id_jenislaporan, b.no_registrasi");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_kategori($params = array()) {
		$res=DB::table("t_putusan_kategori as a")
		     ->leftJoin("m_kajianakhir_kategori as d","d.id","=","a.id_kat1")
			 ->leftJoin("m_kajianakhir_kategori as e","e.id","=","a.id_kat2")
			 ->leftJoin("m_kajianakhir_kategori as f","f.id","=","a.id_kat3")
			 ->selectRaw("a.*, d.nama kat1nm, e.nama kat2nm, f.nama kat3nm ");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_putusan'])){
			$res=$res->where('a.id_putusan',$params['id_putusan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		else{
			$res=null;
		}
		return $res;
	}
	static function daftar_dokumen($params = array()) {
		$res=DB::table("t_putusan_dokumen as a")
		     ->join("m_user as b","b.id_user","=","a.create_by")
			 ->selectRaw("a.*, b.nama");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_putusan'])){
			$res=$res->where('a.id_putusan',$params['id_putusan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_putusan::where('id','=',$data['id'])->first();
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['rekomendasi_no'])) {
	            $res->rekomendasi_no=getinpa($data['rekomendasi_no']);
	        }
			if (isset($data['rekomendasi_file'])) {
	            $res->rekomendasi_file=getinpa($data['rekomendasi_file']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_putusan;
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['rekomendasi_no'])) {
	            $res->rekomendasi_no=getinpa($data['rekomendasi_no']);
	        }
			if (isset($data['rekomendasi_file'])) {
	            $res->rekomendasi_file=getinpa($data['rekomendasi_file']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_dokumen($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_putusan_dokumen::where('id','=',$data['id'])->first();
			if (isset($data['id_putusan'])) {
	            $res->id_putusan=getinpa($data['id_putusan']);
	        }
			if (isset($data['no'])) {
	            $res->no=getinpa($data['no']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_putusan_dokumen;
			if (isset($data['id_putusan'])) {
	            $res->id_putusan=getinpa($data['id_putusan']);
	        }
			if (isset($data['no'])) {
	            $res->no=getinpa($data['no']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_kategori($params = array(),$data=null){
		self::del_kategori($params['id_putusan']);
		$res=DB::table('t_putusan_kategori')->insert($data);
		return $res;
	}
	static function upd($data = array()) {
		$res=M_putusan::where('id',$data['id'])->first();
        $res->note=getinpa($data['note']);
        $res->dokumen=getinpa($data['dokumen']);
        $res->edit_by=$data['edit_by'];
        $res->edit_date=$data['edit_date'];
		$res->save();
		$affect_row=1;
        return true;
	}
	static function del($id) {
		M_putusan_dokumen::where('id_putusan',$id)->delete();
		M_putusan::where('id',$id)->delete();
    }
	static function del_dokumen($id) {
		M_putusan_dokumen::where('id',$id)->delete();
    }
	static function del_kategori($id) {
		DB::table('t_putusan_kategori')->where('id_putusan',$id)->delete();
    }
}
