<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class M_notifikasi extends Model
{
    public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_notifikasi';
    protected $fillable = [
	'id_user',
	'pesan',
	'url',
	'tanggal_buat',
	'sts_baca',
	'tanggal_baca'
	];
	public static function daftar($params = array()){
		$res=DB::table('m_notifikasi');
		if (isset($params['id'])) {
			$res=$res->where('id',"=",$params['id']);
        }
		if (isset($params['id_pelapor'])) {
			$res=$res->where('id',"=",$params['id_pelapor']);
        }
		if (isset($params['cari'])) {
			$res=$res->whereRaw("(lower(pesan) like '%".$params['cari']."%' or lower(sf_formatTanggal(tanggal_buat)) like '%".strtolower($params['cari'])."%') ");
        }
		$res=$res->orderBy('id', 'desc');
		if (isset($params['id'])) {
            return $res->first();
        } else {
            return $res->get();
        }
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_notifikasi::where('id','=',$data['id'])->first();
			if(isset($data['id_user'])){
				$res->id_user=getinpa($data['id_user']);
			}
			if(isset($data['pesan'])){
				$res->pesan=getinpa($data['pesan']);
			}
			if(isset($data['url'])){
				$res->url=getinpa($data['url']);
			}
			if(isset($data['tanggal_buat'])){
				$res->tanggal_buat=getinpa($data['tanggal_buat']);
			}
			if(isset($data['sts_baca'])){
				$res->sts_baca=getinpa($data['sts_baca']);
			}
			if(isset($data['tanggal_baca'])){
				$res->tanggal_baca=getinpa($data['tanggal_baca']);
			}
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_notifikasi;
			if(isset($data['id_user'])){
				$res->id_user=getinpa($data['id_user']);
			}
			if(isset($data['pesan'])){
				$res->pesan=getinpa($data['pesan']);
			}
			if(isset($data['url'])){
				$res->url=getinpa($data['url']);
			}
			if(isset($data['tanggal_buat'])){
				$res->tanggal_buat=getinpa($data['tanggal_buat']);
			}
			if(isset($data['sts_baca'])){
				$res->sts_baca=getinpa($data['sts_baca']);
			}
			if(isset($data['tanggal_baca'])){
				$res->tanggal_baca=getinpa($data['tanggal_baca']);
			}
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function del($id){
		M_notifikasi::where('id',$id)->delete();
    }
}
