<?php

namespace App\Models;

use DB;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    use HasFactory, Notifiable;
	
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $keyType      = 'string';
    protected $primaryKey   = 'id_user';
	protected $table = 'm_user';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nama',
		'nm_user',
		'password',
		'aktif',
		'foto_diri',
		'foto_identitas',
		'jenis_noidentitas',
		'no_identitas',
		'tempat_lahir',
		'tanggal_lahir',
		'jenis_kelamin',
		'pekerjaan',
		'pekerjaan_lain',
		'warganegara',
		'alamat',
		'provinsi',
		'kabkota',
		'wilayah',
		'hp',
		'fax',
		'email',
		'id_katpelapor',
		'id_kappelapor',
		'kappelapor',
		'status',
		'jabatan',
		'stsvalid_by',
		'stsvalid_date',
		'locus_daftar',
		'email_verified_at',
		'remember_token',
		'create_by',
		'create_date',
		'edit_by',
		'edit_date'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
	
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
	static function daftar($params = array()) {
		$str="  select a.*,b.nama nama_role,coalesce(a.foto,'profil.jpg') foto,
				(case when posisi=0 then 'Bawaslu RI' 
				      when posisi=1 then 
		          		(case when coalesce(kabkota,'')<>'' then 
		    				concat('Propinsi : ',(select nama from m_provinsi where a.provinsi=kode),'<br>Kabupaten : ',(select nama from m_kabkota where a.kabkota=kode))
		    			else  
		    				concat('Propinsi : ',(select nama from m_provinsi where a.provinsi=kode))
		    			end) 
					  when posisi=2 then concat('Negara : ',(select nama from m_negara where a.wilayah=kode))   
					  when posisi=3 then 'Instansi'  
				end) posisinm,
				(case when aktif=1 then 'Aktif' else 'Tidak Aktif' end) nm_aktif,
				(case when stswa=1 then 'Aktif' else 'Tidak Aktif' end) stswa_nmaktif
				from m_user a
				left join m_role b on a.id_role=b.id_role
				where 1<2 ";
		if(isset($params['id'])){
			$str.=" and id_user=".$params['id'];
        }
		if(isset($params['uwilayah'])){
			$wil=$params['uwilayah'];
			if($wil=='0'){
				//do nothing
			}
			elseif(substr($wil,3,2)=='00'){
				$str.=" and substr(wilayah,1,2)=".substr($wil,0,2);
			}
			else{
				$str.=" and wilayah=".$wil;
			}
        }
		$res=DB::select($str);
		//$res=DB::table('vw_list_muser');
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_role(){
		return DB::table('m_role')->get();
	}
	static function cekuser($id){
		$str="select a.*,
		(case when posisi=1 then (select nama from m_provinsi where a.provinsi=kode) else '' end) provinsinm,
		(case when posisi=1 then (select nama from m_kabkota where a.kabkota=kode) else '' end) kabkotanm
		from m_user a where posisi<3 ";
		if (isset($id)) {
			$str.=" and id_user=".$id;
        }
		$res=DB::select($str);
		return $res;
	}
	static function cekadd($data = array()){
		$res=DB::table('m_user')->select('id_user');
		if (isset($data['nm_user'])) {
			$res=$res->where('nm_user','=', $data['nm_user']);
        }
		return $res->first();
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=Admin::where('id_user','=',$data['id'])->first();
			if(isset($data['nama'])){
				$res->nama=getinpa($data['nama']);
			}
			if(isset($data['nm_user'])){
				$res->nm_user=getinpa($data['nm_user']);
			}
			if(isset($data['sandi'])){
				$res->sandi=getinpa(sha1($data['sandi']));
				$res->password=getinpa(bcrypt($data['sandi']));
			}
			if(isset($data['id_role'])){
				$res->id_role=getinpa($data['id_role']);
			}
			if(isset($data['foto'])){
				$res->foto=getinpa($data['foto']);
			}
			if(isset($data['jabatan'])){
				$res->jabatan=getinpa($data['jabatan']);
			}
			if(isset($data['hp'])){
				$res->hp=getinpa($data['hp']);
			}
			if(isset($data['email'])){
				$res->email=getinpa($data['email']);
			}
			if(isset($data['posisi'])){
				$res->posisi=getinpa($data['posisi']);
			}
			if(isset($data['provinsi'])){
				$res->provinsi=getinpa($data['provinsi']);
			}
			if(isset($data['kabkota'])){
				$res->kabkota=getinpa($data['kabkota']);
			}
			if(isset($data['wilayah'])){
				$res->wilayah=getinpa($data['wilayah']);
			}
			if(isset($data['aktif'])){
				$res->aktif=getinpa($data['aktif']);
			}
			if(isset($data['stswa'])){
				$res->stswa=getinpa($data['stswa']);
			}
			if(isset($data['create_by'])){
				$res->create_by=getinpa($data['create_by']);
			}
			if(isset($data['create_date'])){
				$res->create_date=getinpa($data['create_date']);
			}
			if(isset($data['edit_by'])){
				$res->edit_by=getinpa($data['edit_by']);
			}
			if(isset($data['edit_date'])){
				$res->edit_date=getinpa($data['edit_date']);
			}
			$res->save();
			$sffect_row=1;
		}
		else{
			$res=new Admin;
			if(isset($data['nama'])){
				$res->nama=getinpa($data['nama']);
			}
			if(isset($data['nm_user'])){
				$res->nm_user=getinpa($data['nm_user']);
			}
			if(isset($data['sandi'])){
				$res->sandi=getinpa(sha1($data['sandi']));
				$res->password=getinpa(bcrypt($data['sandi']));
			}
			if(isset($data['id_role'])){
				$res->id_role=getinpa($data['id_role']);
			}
			if(isset($data['foto'])){
				$res->foto=getinpa($data['foto']);
			}
			if(isset($data['jabatan'])){
				$res->jabatan=getinpa($data['jabatan']);
			}
			if(isset($data['hp'])){
				$res->hp=getinpa($data['hp']);
			}
			if(isset($data['email'])){
				$res->email=getinpa($data['email']);
			}
			if(isset($data['posisi'])){
				$res->posisi=getinpa($data['posisi']);
			}
			if(isset($data['provinsi'])){
				$res->provinsi=getinpa($data['provinsi']);
			}
			if(isset($data['kabkota'])){
				$res->kabkota=getinpa($data['kabkota']);
			}
			if(isset($data['wilayah'])){
				$res->wilayah=getinpa($data['wilayah']);
			}
			if(isset($data['aktif'])){
				$res->aktif=getinpa($data['aktif']);
			}
			if(isset($data['stswa'])){
				$res->stswa=getinpa($data['stswa']);
			}
			if(isset($data['create_by'])){
				$res->create_by=getinpa($data['create_by']);
			}
			if(isset($data['create_date'])){
				$res->create_date=getinpa($data['create_date']);
			}
			if(isset($data['edit_by'])){
				$res->edit_by=getinpa($data['edit_by']);
			}
			if(isset($data['edit_date'])){
				$res->edit_date=getinpa($data['edit_date']);
			}
			$res->save();
			$id=$res->id_user;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function del($id){
		DB::table('m_user')->where('id_user',$id)->delete();
    }
}
