<?php
namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_modulinfo;
use App\Models\M_laporan;
use App\Models\N_klarifikasi;
use App\Models\M_klarifikasi;
use Illuminate\Http\Request;
use Carbon\Carbon;

class N_KlarifikasiController extends Controller
{
	public function __construct()
    {
    }
	function index($year = null, $month = null, $day = null){
		if(!cekintnull($year)||!cekintnull($month)||!cekintnull($day)){
			return redirect()->route('denied.index');
		}
		
		$title = 'Jadwal Klarifikasi';
     	$main = 'home.klarifikasi';
		$arrLink=array(
				array("Menu",route('home').'/'.(session('ujenislaporanid')==1?'pemilihan':'pemilu').'/'.session('ulocuskode')),
				);
		
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('m');
		$day   = (is_numeric($day) &&  $day > 0 && $day < 31)?  $day : '';
		$params['year']=$year;
		$params['month']=$month;
		$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif',1)->first()->id;
		$params['id_jenislaporan'] = session('ujenislaporanid');
		$params['locus'] =session('ulocuskode');
		$params['id_pelapor'] =session('uid');
		$date= N_klarifikasi::getDateEvent($params);
		//echo json_encode($date);
		//die();
		$notes=self::generate($year, $month, $date);
		if($year!=""&&$month!=""&&$day!=""){
			$params['tanggal']=$year.'-'.$month.'-'.$day;
		}
		else{
			$yeara  = ($month < 10 && strlen($month) == 1) ? "$year-0$month" : "$year-$month";
			$params['tahunbulan']=$yeara;
		}
		$list = M_klarifikasi::daftar($params);
		$lebar=12;
		$paramsmodulinfo['id_jenislaporan'] =session('ujenislaporanid');
		$paramsmodulinfo['modul'] ='jadwal-klarifikasi';
		$modulinfo = M_modulinfo::daftar($paramsmodulinfo)[0]['deskripsi'];
		return view($main,compact('arrLink','title','list','lebar','modulinfo','notes','year','month'));
	}
	// for convert (int) month to (string) month in Indonesian
	function _month($month){
		if(!cekintnull($month)){
			return redirect()->route('denied.index');
		}
		$month = (int) $month;
		switch($month){
			case 1 : $month = 'Januari'; Break;
			case 2 : $month = 'Februari'; Break;
			case 3 : $month = 'Maret'; Break;
			case 4 : $month = 'April'; Break;
			case 5 : $month = 'Mei'; Break;
			case 6 : $month = 'Juni'; Break;
			case 7 : $month = 'Juli'; Break;
			case 8 : $month = 'Agustus'; Break;
			case 9 : $month = 'September'; Break;
			case 10 : $month = 'Oktober'; Break;
			case 11 : $month = 'November'; Break;
			case 12 : $month = 'Desember'; Break;
		}
		return $month;
	}
	function generate($year = null, $month = null, $dt = null)
	{
		$year  = (empty($year) || !is_numeric($year))?  date('Y') :  $year;
		$month = (is_numeric($month) &&  $month > 0 && $month < 13)? $month : date('m');
		$day   = 1;
		
		if(empty($year)&&empty($month)&&empty($day)){
			$date=Carbon::now();
		}
		else{
			$date=$year.'-'.$month.'-'.$day;
			$date=Carbon::createFromDate($date);
		}
		$n_month=0;
		$n_year=0;
		if($month==12){
			$n_month=1;
			$n_year=$year+1;
		}
		else{
			$n_month=self::checkstr($month+1);
			$n_year=$year;
		}
		$b_month=0;
		$b_year=0;
		if($month==1){
			$b_month=12;
			$b_year=$year-1;
		}
		else{
			$b_month=self::checkstr($month-1);
			$b_year=$year;
		}
		
	    $startOfCalendar = $date->copy()->firstOfMonth()->startOfWeek(Carbon::SUNDAY);
	    $endOfCalendar = $date->copy()->lastOfMonth()->endOfWeek(Carbon::SATURDAY);
		
	    $html = '<div class="calendar">';
		$html .= '<div class="prev_next">';
	    $html .= '<button class="arrow" onclick=javascript:godt("'.$b_year.'","'.$b_month.'","")><i class="material-icons">chevron_left</i></button><div style="height:10px"></div>';
	    $html .= '<button class="arrow" onclick=javascript:godt("'.$n_year.'","'.$n_month.'","")><i class="material-icons">chevron_right</i></button>';
		$html .= '</div>';
	    $html .= '<div class="month-year">';
	    $html .= '<span class="month">' . $date->format('M') . '</span>';
	    $html .= '<span class="year">' . $date->format('Y') . '</span>';
	    $html .= '</div>';
	
	    $html .= '<div class="days">';
	
	    $dayLabels = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
	    foreach ($dayLabels as $dayLabel)
	    {
	        $html .= '<span class="day-label">' . $dayLabel . '</span>';
	    }
	
	    while($startOfCalendar <= $endOfCalendar)
	    {
	        $extraClass = $startOfCalendar->format('m') != $date->format('m') ? 'dull' : '';
	        $extraClass .= $startOfCalendar->isToday() ? ' today' : '';
	
	        $evt='';
			if($startOfCalendar->format('m') == $date->format('m')){
				$evt=self::chekevent($dt,$startOfCalendar->format('j'));
			}
			$lendt=strlen($startOfCalendar->format('j'));
			$lendt=($lendt==2?'1':'');
			if($evt!=''){
				$html .= '<span class="day '.$extraClass.'"><span class="content"><span class="date-with-event'.$lendt.'" onclick=javascript:godt("'.$year.'","'.self::checkstr($month).'","'.self::checkstr($startOfCalendar->format('j')).'")>' . $startOfCalendar->format('j') . '</span><span class="event-count">'.$evt.'</span></span></span>';
	        }
			else{
				$html .= '<span class="day1 '.$extraClass.'"><span class="content">' . $startOfCalendar->format('j') . '</span></span>';
	        }
			$startOfCalendar->addDay();
	    }
	    $html .= '</div></div>';
		return $html;
	}
	function checkstr($m){
		$s='';
		if($m!=''){
			$s=(strlen($m)==1?'0':'');
			$s.=$m;
		}
		return $s;
	}
	function chekevent($dt,$day){
		$s='';
		if(!empty($dt)){
			foreach($dt as $key=>$val){
				if($day==$key){
					$s=$val;
				}
			}
		}
		return $s;
	}
	function jadwal(){
		$title = 'Jadwal Klarifikasi';
     	$main = 'home.klarifikasi_jadwal';
		$arrLink=array(
				array("Menu",route('home').'/'.(session('ujenislaporanid')==1?'pemilihan':'pemilu').'/'.session('ulocuskode')),
				);
		$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif',1)->first()->id;
		$params['id_jenislaporan'] = session('ujenislaporanid');
		$params['locus'] =session('ulocuskode');
		$params['id_pelapor'] =session('uid');
		$list = M_klarifikasi::daftar($params);
		$lebar=12;
		return view($main,compact('arrLink','title','list','lebar'));
	}
	function proses($id_klarifikasi=null){
		if(!cekintnull(dc($id_klarifikasi))){
			return redirect()->route('denied.index');
		}
		$id_klarifikasi=dc($id_klarifikasi);
		$title = 'Proses Klarifikasi';
     	$main = 'home.klarifikasi_proses';
		$arrLink=array(
				array("Menu",route('home').'/'.(session('ujenislaporanid')==1?'pemilihan':'pemilu').'/'.session('ulocuskode')),
				);
		$params['id_klarifikasi'] = $id_klarifikasi;
		$list = M_klarifikasi::daftar_prosesurutstep($params);
		$listberkas = M_klarifikasi::daftar_berkas($params);
		
		$paramsa['id'] = $id_klarifikasi;
		$data = M_klarifikasi::daftar($paramsa);
		$lebar=12;
		return view($main,compact('arrLink','title','list','listberkas','lebar','data','id_klarifikasi'));
	}
}