<?php

namespace App\Http\Controllers;

use DB;
use App\Models\Admin;
use App\Models\M_jabatan;
use App\Models\M_log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;
use Session;
use DateTime;

class M_UserController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("User",route('m_user.index'))
		);
		$title='Daftar User';
		$tambah=null;
		if(session('be_urole')==1||session('be_urole')==3){
			$tambah = 'href="'.route('m_user.add').'"';
		}
		return view('be.m_user_list',compact('arrLink','title','tambah'));
    }
	public function daftar()
    {
		$data=Admin::daftar();
	}
	public function cekuser(Request $request){
		$params['nm_user'] = getinp($request->u);
		$cek=Admin::cekadd($params);
		if(!$cek){
			echo -1;
		}
	}
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' user';
		$arrLink=array(
				array("User",route('m_user.index'))
				);
		$params['id'] =$id;
		$role= Admin::daftar_role();
		$m_jabatan=M_jabatan::daftar();
		$m_provinsi=null;
		$m_negara=null;
		if(session('be_uwilayah')=='0'){
			$m_provinsi=DB::table('m_provinsi')->get();
			$m_negara=DB::table('m_negara')->get();
		}
		else{
			if(substr(session('be_uprovinsi'),3,2)=='00'){
				$m_kabkota=DB::table('m_kabkota')->whereRaw('substring(kode, 1,  2) = '.substr(session('be_uprovinsi'),0,2))->get();
			}
		}
		$negara='';
		$data=null;
		$m_kabkota=null;
		if(isset($id)){
			$data=Admin::daftar($params);
			if($data){
				if(strlen($data->wilayah)==2){
					$negara=$data->wilayah;
				}
				if($data->provinsi!=""){
					$m_kabkota=DB::table('m_kabkota')->whereRaw('substring(kode, 1,  2) = '.substr($data->provinsi,0,2))->get();
				}
			}
		}
		return view('be.m_user_add',compact('arrLink','operation','title','role','m_jabatan','m_provinsi','m_negara','m_kabkota','negara','data'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' user';
		$arrLink=array(
				array("User",route('m_user.index'))
				);
		$params['id'] =$id;
     	$role = DB::table('m_role')->get();
		$m_provinsi = DB::table('m_provinsi')->get();
		$m_negara = DB::table('m_negara')->get();
		
		$negara='';
		$data=null;
		if(isset($id)){
			$data=Admin::daftar($params);
			if($data){
				if(strlen($data->wilayah)==2){
					$negara=$data->wilayah;
				}
			}
		}
		return view('be.m_user_view',compact('arrLink','operation','title','role','m_provinsi','m_negara','negara','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['id_role'] = getinp($request->id_role);
		$params['nama'] = getinp($request->nama);
		$params['jabatan'] = getinp($request->jabatan);
		$params['nm_user'] = getinp($request->nm_user);
		$params['posisi'] = getinp($request->posisi);
		$params['provinsi'] = getinp($request->provinsi);
		$params['kabkota'] = getinp($request->kabkota);
		$params['hp'] = getinp($request->hp);
		$params['email'] = getinp($request->email);
		$params['stswa'] = getinp($request->stswa);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		$msg="";
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
	        $validator = Validator::make($request->all(), [
	            'nm_user' => 'required|unique:mysql.m_user',
	            'nama' => 'required',
	            'id_role' => 'required',
	            'aktif' => 'required',
				'foto' => 'mimes:jpeg,jpg,gif,png|max:5128'
	        ]);
			$msg="Data berhasil ditambah";
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
	        $validator = Validator::make($request->all(), [
	            'nama' => 'required',
	            'id_role' => 'required',
	            'aktif' => 'required',
				'foto' => 'mimes:jpeg,jpg,gif,png|max:5128'
	        ]);
			$msg="Data berhasil diubah";
		}
		if ($validator->fails()){
            return response()->json([
                'alert' => 'error',
                'message' => $validator->errors()->first(),
            ]);
        }
		
		if($params['posisi']==1){
			if($params['kabkota']!=""){
				$params['wilayah']=$params['kabkota'];
			}
			else{
				$params['wilayah']=$params['provinsi'];
			}
		}
		elseif($params['posisi']==2){
			$params['wilayah']=getinp($request->negara);
			$params['provinsi']='';
			$params['kabkota']='';
		}
		else{
			$params['provinsi']='';
			$params['kabkota']='';
			$params['wilayah']='0';
		}
		$params['sandi'] = getinpb($request->sandi);
		$params['aktif'] = $request->aktif;
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Tambah'){
			$paramscek['nm_user'] =$params['nm_user'];
			$cek=Admin::cekadd($paramscek);
			if($cek){
				//Session::flash('failed', 'Username sudah terdaftar!');
				$request->session()->flash('failed', 'Username sudah terdaftar!');
				return redirect()->route('m_user.index')->with('failed', 'Username sudah terdaftar...');
			}
		}
		else{
			$params['nm_user'] =null;
		}
		
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=Admin::add($params);
			if($dt['operation']=='Tambah'){
				$id=$data;
			}
			if (!empty($request->file('foto'))){
				$file=$request->file('foto');
				$file_name=$file->getClientOriginalName();
				$file_ext=$file->extension();
				$date=new DateTime();
				$namafile=aksi_upload($file,'foto',$date->format('Y-m-d-H-i-s').'-'.$file_name,$file_ext);
				$paramsupd['foto'] = $namafile;
				$paramsupd['id']=$id;
				$data=Admin::add($paramsupd);
			}
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		//echo route('m_user.index');
		//return redirect()->route('m_user.index')->with('success', $dt['operation'] . ' Data Berhasil');
        return response()->json([
            'alert' => 'success',
            'message' => $msg,
        ]);
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from t_laporan where create_by=".$id." or edit_by=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_user.index')->with('failed', 'Hapus Data Tidak Berhasil');
		}
		else{
			$str="select nama from m_user where id_user=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: User '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			Admin::del($id);
			return redirect()->route('m_user.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function list_result(Request $request):JsonResponse
	{
		//if($request->ajax()){
			//$collection = DB::table('vw_daftar_muser')->get();
			$wil=session('be_uwilayah');
			$str="select a.*,b.nama nama_role,
					(case when posisi=0 then 'Bawaslu RI' when posisi=1 then  
			      		(case when coalesce(kabkota,'')<>'' then 
							concat('Propinsi : ',(select nama from m_provinsi where a.provinsi=kode),'<br>Kabupaten : ',(select nama from m_kabkota where a.kabkota=kode))
						else  
							concat('Propinsi : ',(select nama from m_provinsi where a.provinsi=kode))
						end)
						when posisi=2 then concat('Negara : ',(select nama from m_negara where a.wilayah=kode)) 
						when posisi=3 then 'Instansi' 
					end) posisinm,
					(case when aktif=1 then 'Aktif' else 'Tidak Aktif' end) nm_aktif,
					(case when stswa=1 then 'Aktif' else 'Tidak Aktif' end) stswa_nmaktif,
					coalesce((select '1' from t_laporan where create_by=a.id_user limit 1),'') sts_lock
					from m_user a 
					left join m_role b on a.id_role=b.id_role where 1<2 ";
			if (isset($wil)) {
				if($wil=='0'){
					//do nothing
				}
				elseif(substr($wil,3,2)=='00'){
					$str.=" and substr(wilayah,1,2)='".substr($wil,0,2)."'";
				}
				else{
					$str.=" and wilayah='".$wil."'";
				}
	        }
			$collection = DB::select($str);
			return DataTables::of($collection)
			->addColumn('id_user_ec', function ($arrData){
				return ec($arrData->id_user);
			})
			->editColumn('posisinm', function ($arrData){
				return str_replace('<br>',', ',$arrData->posisinm);;
			})
			->addColumn('posisinm_a', function ($arrData){
				return $arrData->posisinm;
			})
			->make(true);
		//}
    }
}
