<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_status;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_StatusController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Status",route('m_status.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Status';
		$tambah = 'href="'.route('m_status.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_status_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_status::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('dokumen_covers', function ($arrData){
				$s='';
				if($arrData->dokumen_cover!=''){
					$s.='<a href="'.route("download.be_sts_dk").'/'.rawurlencode($arrData->dokumen_cover).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('dokumens', function ($arrData){
				$s='';
				if($arrData->dokumen!=''){
					$s.='<a href="'.route("download.be_sts_dk").'/'.rawurlencode($arrData->dokumen).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_status.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_status.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;$tambah=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_status::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				$id_jenislaporan=$data->id_jenislaporan;
				
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		$title = 'Tambah status';
     	$main = 'be.m_status_add';
     	$arrLink=array(
				array("status",route('m_status.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_status.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		
		$m_status = DB::table('m_status_kategori')->get();
		$params['locus'] =session('be_uwilayah');
     	$params['table'] = 't_status';
		if($id_jenislaporan==3){
     		$params['stsposisi'] = 'Putusan';
		}
		else{
     		$params['stsposisi'] = 'Kajian Akhir';
		}
		$listlaporan = M_laporan::daftartidakdengannoreg($params);
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_status','listlaporan'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;$tambah=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_status::daftar($paramsdt);
			if($data){
				$id_jenislaporan=$data->id_jenislaporan;
				if(!General::cekaksesview($data->locus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$title = 'Status';
     	$main = 'be.m_status_view';
     	$arrLink=array(
				array("status",route('m_status.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_status.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		$m_status = DB::table('m_status_kategori')->get();
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_status'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['id_kat1'] = getinp($request->id_kat1);
		$params['note'] = getinp($request->note);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		$datalap=null;$tambah=null;
		
		if($dt['operation']=='Ubah'){
			$datalap=DB::table("t_status as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->selectRaw('b.no,b.locus,b.stsposisi')
					 ->where('a.id',$id)->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$stsposisi=$datalap->stsposisi;
				$ceklocus=$datalap->locus;
				
				if(General::cekaksesedit($ceklocus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			$datalap=DB::table("t_laporan")
					 ->selectRaw('no,locus,stsposisi')
					 ->where('id',$params['id_laporan'])->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$ceklocus=$datalap->locus;
				$cekstsposisi=$datalap->stsposisi;
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Status Laporan';
		M_laporan::setposisi($paramslaporan);
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_status::add($params);
		if($data){
			$id=$data;
		}
		$no=DB::table("t_laporan")->select('no')->where('id',$params['id_laporan'])->first()->no;
		if (!empty($request->file('dokumen_cover'))){
			$file=$request->file('dokumen_cover');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'status',$no.'-'.$date->format('Y-m-d-H-i-s').'-slide',$file_ext);
			$paramsupd['dokumen_cover'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_status::add($paramsupd);
		}
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'status',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_status::add($paramsupd);
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Status',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Status dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_status.index').'/'.ec($id_jenislaporan);
	}
	function del($id_jenislaporan=null,$id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table("t_status as a")->join('t_laporan as b','a.id_laporan','=','b.id')
				 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$data=M_status::del($id);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Status',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Status dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		if($id_jenislaporan==3){
			$params['stsposisi']='Putusan';
		}
		else{
			$params['stsposisi']='Kajian Akhir';
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Status',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		return redirect()->route('m_status.index',[$ec_id_jenislaporan]);
	}
}
