<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_laporan;
use App\Models\General;
use App\Models\M_sidang;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_SidangController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Sidang';
		$tambah = 'href="'.route('m_sidang.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_sidang_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_sidang::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('no', function ($arrData){
				return $arrData->no;
			})
			->addColumn('no_ringkasan', function ($arrData){
				return $arrData->no.' - '.$arrData->ringkasan;
			})
			->addColumn('no_ringkasan_short', function ($arrData){
				return $arrData->no.'<br><br>'.substr($arrData->ringkasan,0,50).'...';
			})
			->addColumn('tanggal_jadwal', function ($arrData){
				return konversi_tanggal('d-M-Y H:i:s',$arrData->tanggal,'idshort');
			})
			->addColumn('proses_short', function ($arrData){
				return substr($arrData->proses,0,50).'...';
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_sidang.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_sidang.daftar_proses').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="ti-settings"></i> Proses</a>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_sidang.daftar_berkas').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Berkas</a>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_sidang.daftar_risalah').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="ti-clipboard"></i> Risalah</a>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_sidang.daftar_putusan').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="ti-save-alt"></i> Amar Putusan</a>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_sidang.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function daftar_proses($id_jenislaporan=null,$id_sidang=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$datalap=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$data['locus']='';$data['stsposisi']='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Proses Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangproses_list';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		
		$params['id_sidang'] = $id_sidang;
		$list = M_sidang::daftar_proses($params);
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','list'));
	}
	function daftar_berkas($id_jenislaporan=null,$id_sidang=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$datalap=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Berkas Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangberkas_list';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Berkas",route('m_sidang.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		$params['id_sidang'] = $id_sidang;
		$list = M_sidang::daftar_berkas($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','list'));
	}
	function daftar_putusan($id_jenislaporan=null,$id_sidang=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$datalap=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Putusan Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangputusan_list';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Putusan",route('m_sidang.daftar_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		$params['id_sidang'] = $id_sidang;
		$list = M_sidang::daftar_putusan($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','list'));
	}
	function daftar_risalah($id_jenislaporan=null,$id_sidang=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$datalap=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Risalah Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangrisalah_list';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Risalah",route('m_sidang.daftar_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		$params['id_sidang'] = $id_sidang;
		$list = M_sidang::daftar_risalah($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','list'));
	}
	function daftar_dokumen($id_jenislaporan=null,$id_sidang=null,$id_sidangproses=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id_sidangproses))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id_sidangproses=$id_sidangproses;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id_sidangproses=dc($id_sidangproses);
		$datalap=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$paramsgetproses['id']=$id_sidangproses;
		$proses =M_sidang::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Sidang <br><font class=subjudul>'.$no.'<br>Step : '.$proses->stepnm.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'be.m_sidangdok_list';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang),
				array("Dokumen",route('m_sidang.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'/'.$ec_id_sidangproses)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'/'.$ec_id_sidangproses.'"';
		}
		
		$data['id_sidangproses']=$id_sidangproses;
		$params['id_sidangproses'] = $id_sidangproses;
		$params['id_sidang'] = $id_sidang;
		$list = M_sidang::daftar_dokumen($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','id_sidangproses','no','locus','stsposisi','proses','list'));
	}
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;$tambah=null;$listlaporan=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_sidang::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				$id_jenislaporan=$data->id_jenislaporan;
				
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
		}
		$title = 'Tambah Sidang';
     	$main = 'be.m_sidang_add';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_sidang.add').'/'.$ec_id_jenislaporan.'"';
		$params['id_jenislaporan'] = $id_jenislaporan;
     	$params['table'] = 't_sidang';
     	$params['locus'] = session('be_uwilayah');
		$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif',1)->first()->id;
		if(empty($id)){
			$listlaporan = M_laporan::daftardengannoreg($params,'');
		}
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;$tambah=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_sidang::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$id_jenislaporan=$data->id_jenislaporan;
				
				if(!General::cekaksesview($locus)){
					return redirect()->route('denied');
				}
			}
		}
		$title = 'Sidang';
     	$main = 'be.m_sidang_view';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_sidang.add').'/'.$ec_id_jenislaporan.'"';
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data'));
	}
	function add_proses($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Proses Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangproses_add';
     	$arrLink=array(
				array("sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		$tambah = 'href="'.route('m_sidang.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		$m_sidang_step =DB::table('m_sidang_step')->get();
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_proses($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','no','locus','m_sidang_step','data'));
	}
	function view_proses($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		
		$title = 'Proses Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangproses_view';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		$m_sidang_step =DB::table('m_sidang_step')->get();
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_proses($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','datalap','no','locus','m_sidang_step','data'));
	}
	function add_berkas($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Berkas Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangberkas_add';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Berkas",route('m_sidang.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		$tambah = 'href="'.route('m_sidang.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_berkas($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','no','locus','data'));
	}
	function view_berkas($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		
		$title = 'Berkas Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangberkas_view';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Berkas",route('m_sidang.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_berkas($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','data'));
	}
	function add_putusan($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$title = 'Putusan Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangputusan_add';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Putusan",route('m_sidang.daftar_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		$tambah = 'href="'.route('m_sidang.add_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_putusan($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','no','locus','stsposisi','data'));
	}
	function view_putusan($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		
		$title = 'Putusan Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangputusan_view';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Putusan",route('m_sidang.daftar_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_putusan').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_putusan($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_sidang','no','locus','stsposisi','data'));
	}
	function add_risalah($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$title = 'Risalah Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangrisalah_add';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Risalah",route('m_sidang.daftar_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		$tambah = 'href="'.route('m_sidang.add_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_risalah($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','no','locus','stsposisi','data'));
	}
	function view_risalah($id_jenislaporan=null,$id_sidang = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		
		$title = 'Risalah Sidang <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_sidangrisalah_view';
     	$arrLink=array(
				array("Sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Risalah",route('m_sidang.daftar_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_risalah').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'"';
		}
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_risalah($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','tambah','no','locus','stsposisi','data'));
	}
	function add_dokumen($id_jenislaporan=null,$id_sidang = NULL,$id_sidangproses=null,$id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id_sidangproses))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id_sidangproses=$id_sidangproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id_sidangproses=dc($id_sidangproses);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		$paramsgetproses['id']=$id_sidangproses;
		$proses =M_sidang::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Sidang <br><font class=subjudul>'.$no.'<br>Step : '.$proses->proses.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'be.m_sidangdok_add';
     	$arrLink=array(
				array("sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_sidang),
				array("Dokumen",route('m_sidang.daftar_dokumen').'/'.$ec_id_sidang.'/'.$ec_id_sidangproses)
				);
		$tambah = 'href="'.route('m_sidang.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'/'.$ec_id_sidangproses.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_dokumen($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','id_sidangproses','tambah','no','locus','stsposisi','proses','data'));
	}
	function view_dokumen($id_jenislaporan=null,$id_sidang = NULL,$id_sidangproses=null,$id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id_sidangproses))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id_sidangproses=$id_sidangproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id_sidangproses=dc($id_sidangproses);
		$id=dc($id);
		$datalap=null;$data=null;$tambah=null;
		
		$paramsgetlap['id']=$id_sidang;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_sidang::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		$paramsgetproses['id']=$id_sidangproses;
		$proses =M_sidang::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Sidang <br><font class=subjudul>'.$no.'<br>Step : '.$proses->proses.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'be.m_sidangdok_view';
     	$arrLink=array(
				array("sidang",route('m_sidang.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_sidang.daftar_proses').'/'.$ec_id_sidang),
				array("Dokumen",route('m_sidang.daftar_dokumen').'/'.$ec_id_sidang.'/'.$ec_id_sidangproses)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_sidang.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_sidang.'/'.$ec_id_sidangproses.'"';
		}
		
		$data['id_sidangproses']=$id_sidangproses;
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_sidang::daftar_dokumen($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_sidang','id_sidangproses','tambah','no','locus','stsposisi','proses','data'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['kuasa_hukum'] = getinp($request->kuasa_hukum);
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Sidang';
		M_laporan::setposisi($paramslaporan);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add($params);
		if($data){
			$id=$data;
		}
		$no=DB::table('t_laporan')->select('no')->where('id',$params['id_laporan'])->first()->no;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.index').'/'.ec($id_jenislaporan);
	}
	function save_proses(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_sidang'] = getinp($request->id_sidang);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_sidang'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['id_step'] = getinp($request->id_step);
		$params['harike'] = getinp($request->harike);
		$params['tanggal'] = getinp($request->tanggal);
		$params['proses'] = getinp($request->proses);
		$params['keterangan'] = getinp($request->keterangan);
		if($params['id']!=""){
			$dt['operation']='Ubah';
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$dt['operation']='Tambah';
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add_proses($params);
		$paramsupd['proses']='';
		if($data){
			$id=$data;
		}
		if(isset($id)){
			$paramsupdparent['id'] = $params['id_sidang'];
			$paramsupdparent['tanggal']=InggrisTglTime(getinpb($params['tanggal']));
			$paramsupdparent['proses']=$params['proses'];
			$paramsupdparent['keterangan']=$params['keterangan'];
			$paramsupdparent['id_proses']=$id;
			$paramsupdparent['edit_by'] =  session('be_uid');
			$paramsupdparent['edit_date'] =  date("Y-m-d H:i:s");
			$data=M_sidang::add($paramsupdparent);
		}
		$no=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.no')->where('a.id',$params['id_sidang'])->first()->no;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang:Proses',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dengan proses '.$params['proses'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.daftar_proses').'/'.ec($id_jenislaporan).'/'.ec($params['id_sidang']);
	}
	function save_berkas(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_sidang'] = getinp($request->id_sidang);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_sidang'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['diserahkan'] = getinp($request->diserahkan);
		$params['banyak'] = getinp($request->banyak);
		$params['keterangan'] = getinp($request->keterangan);
		$params['pihak'] = getinp($request->pihak);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add_berkas($params);
		if($data){
			$id=$data;
		}
		$no=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.no')->where('a.id',$params['id_sidang'])->first()->no;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang:Berkas',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dengan berkas diserahkan oleh '.$params['diserahkan'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.daftar_berkas').'/'.ec($id_jenislaporan).'/'.ec($params['id_sidang']);
	}
	function save_putusan(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_sidang'] = getinp($request->id_sidang);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_sidang'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['deskripsi'] = getinp($request->deskripsi);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add_putusan($params);
		if($data){
			$id=$data;
		}
		$no=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.no')->where('a.id',$params['id_sidang'])->first()->no;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang:Putusan',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dengan putusan '.$params['deskripsi'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.daftar_putusan').'/'.ec($id_jenislaporan).'/'.ec($params['id_sidang']);
	}
	function save_risalah(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_sidang'] = getinp($request->id_sidang);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_sidang'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['proses'] = getinp($request->proses);
		$params['tanggal'] = getinp($request->tanggal);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add_risalah($params);
		if($data){
			$id=$data;
		}
		$no=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.no')->where('a.id',$params['id_sidang'])->first()->no;
		if (!empty($request->file('file_pdf'))){
			$file=$request->file('file_pdf');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'sidang',$no.'-'.$date->format('Y-m-d-H-i-s').'-risalah_pdf',$file_ext);
			$paramsupd['file_pdf'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_sidang::add_risalah($paramsupd);
		}
		if (!empty($request->file('file_audio'))){
			$file=$request->file('file_audio');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'sidang',$no.'-'.$date->format('Y-m-d-H-i-s').'-risalah_audio',$file_ext);
			$paramsupd['file_audio'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_sidang::add_risalah($paramsupd);
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang:Risalah',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dengan risalah '.$params['proses'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.daftar_risalah').'/'.ec($id_jenislaporan).'/'.ec($params['id_sidang']);
	}
	function save_dokumen(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_sidang'] = getinp($request->id_sidang);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_sidang'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['id_sidangproses'] = getinp($request->id_sidangproses);
		$params['deskripsi'] = getinp($request->deskripsi);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_sidang::add_dokumen($params);
		$paramsupd['dokumen']='';
		if($data){
			$id=$data;
		}
		$no=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.no')->where('a.id',$params['id_sidang'])->first()->no;
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'sidang',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_sidang::add_dokumen($paramsupd);
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang:Dokumen',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dengan dokumen '.$params['deskripsi'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_sidang.daftar_dokumen').'/'.ec($id_jenislaporan).'/'.ec($params['id_sidang']).'/'.ec($params['id_sidangproses']);
	}
	function del($id_jenislaporan=null,$id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table('t_sidang as a')->join('t_laporan as b','a.id_laporan','=','b.id')
			->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
		$no='';
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_sidang::del($id);
		
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		$params['stsposisi']='Undangan';
		M_laporan::add($params);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		
		return redirect()->route('m_sidang.index',[ec($id_jenislaporan)]);
	}
	function del_proses($id_jenislaporan=null,$id_sidang=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		
		$no='';$proses='';
		$datalap=DB::table('t_sidang_proses as a')
			->join('t_sidang as b','a.id_sidang','=','b.id')
			->join('t_laporan as c','b.id_laporan','=','c.id')
			->selectRaw('c.no,a.proses')->where('a.id',$id)->first();
		if($datalap){
			$no=$datalap->no;$proses=$datalap->proses;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang::Proses',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan proses '.$proses.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		
		$data=M_sidang::del_proses($id);
		
		$doklast=DB::table('t_sidang_proses')->where('id_sidang',$id_sidang)->orderBy('id', 'desc')->first();
		if($doklast){
			$paramsupdparent['tanggal']=$doklast->tanggal;
			$paramsupdparent['proses']=$doklast->proses;
			$paramsupdparent['keterangan']=$doklast->keterangan;
		}
		else{
			$paramsupdparent['tanggal']='';
			$paramsupdparent['proses']='';
			$paramsupdparent['keterangan']='';
		}
		$paramsupdparent['id']=$id_sidang;
		$paramsupdparent['edit_by'] =  session('be_uid');
		$paramsupdparent['edit_date'] =  date("Y-m-d H:i:s");
		M_sidang::add($paramsupdparent);
		return redirect()->route('m_sidang.daftar_proses',[ec($id_jenislaporan),ec($id_sidang)]);
	}
	function del_berkas($id_jenislaporan=null,$id_sidang=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		
		$no='';$diserahkan='';
		$datalap=DB::table('t_sidang_berkas as a')
			->join('t_sidang as b','a.id_sidang','=','b.id')
			->join('t_laporan as c','b.id_laporan','=','c.id')
			->selectRaw('c.no,a.diserahkan')->where('a.id',$id)->first();
		if($datalap){
			$no=$datalap->no;$diserahkan=$datalap->diserahkan;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang::Berkas',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan berkas '.$diserahkan.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		
		$data=M_sidang::del_berkas($id);
		return redirect()->route('m_sidang.daftar_berkas',[ec($id_jenislaporan),ec($id_sidang)]);
	}
	function del_putusan($id_jenislaporan=null,$id_sidang=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		
		$no='';$deskripsi='';
		$datalap=DB::table('t_sidang_putusan as a')
			->join('t_sidang as b','a.id_sidang','=','b.id')
			->join('t_laporan as c','b.id_laporan','=','c.id')
			->selectRaw('c.no,a.deskripsi')->where('a.id',$id)->first();
		if($datalap){
			$no=$datalap->no;$deskripsi=$datalap->deskripsi;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang::Putusan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan putusan '.$deskripsi.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_sidang::del_putusan($id);
		return redirect()->route('m_sidang.daftar_putusan',[ec($id_jenislaporan),ec($id_sidang)]);
	}
	function del_risalah($id_jenislaporan=null,$id_sidang=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id=dc($id);
		
		$no='';$proses='';
		$datalap=DB::table('t_sidang_risalah as a')
			->join('t_sidang as b','a.id_sidang','=','b.id')
			->join('t_laporan as c','b.id_laporan','=','c.id')
			->selectRaw('c.no,a.proses')->where('a.id',$id)->first();
		if($datalap){
			$no=$datalap->no;$proses=$datalap->proses;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang::Risalah',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan risalah '.$proses.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		
		$data=M_sidang::del_risalah($id);
		return redirect()->route('m_sidang.daftar_risalah',[ec($id_jenislaporan),ec($id_sidang)]);
	}
	function del_dokumen($id_jenislaporan=null,$id_sidang=NULL, $id_sidangproses=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_sidang))||!cekint(dc($id_sidangproses))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_sidang=$id_sidang;
		$ec_id_sidangproses=$id_sidangproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_sidang=dc($id_sidang);
		$id_sidangproses=dc($id_sidangproses);
		$id=dc($id);
		
		$no='';$deskripsi='';
		$datalap=DB::table('t_sidang_prosesfile as a')
			->join('t_sidang_proses as b','a.id_sidangproses','=','b.id')
			->join('t_sidang as c','b.id_sidang','=','c.id')
			->join('t_laporan as d','c.id_laporan','=','d.id')
			->selectRaw('d.no,a.deskripsi')->where('a.id',$id)->first();
		if($datalap){
			$no=$datalap->no;$deskripsi=$datalap->deskripsi;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Sidang::Dokumen',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Sidang dengan pelaporan no '.$no.' dan dokumen '.$deskripsi.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_sidang::del_dokumen($id);
		return redirect()->route('m_sidang.daftar_dokumen',[ec($id_jenislaporan),ec($id_sidang),ec($id_sidangproses)]);
	}
}
