<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_kajianakhir_kategori;
use App\Models\M_putusan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_PutusanController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Sidang",route('m_putusan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Putusan';
		$tambah = 'href="'.route('m_putusan.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_putusan_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = m_putusan::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_putusan.daftar_dokumen').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Dokumen</a>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							       $s.='<li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function add_ajax_kat($id){
		$query=DB::table('m_kajianakhir_kategori')->where('parent_id',$id)->get();
        $data = "<option value=''>- Pilih Kategori -</option>";
        foreach ($query as $value) {
            $data .= "<option value='".$value->id."'>".$value->nama."</option>";
        }
        echo $data;
	}
	function daftar_dokumen($id_jenislaporan=null,$id_putusan=null){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_putusan))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_putusan=$id_putusan;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_putusan=dc($id_putusan);
		$tambah=null;
		
		$paramsgetlap['id']=$id_putusan;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_putusan::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
		}
		$title = 'Dokumen Putusan <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_putusandok_list';
     	$arrLink=array(
				array("Putusan",route('m_putusan.index').'/'.$ec_id_jenislaporan),
				array("Dokumen",route('m_putusan.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan),
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_putusan.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan.'"';
		}
		$params['id_putusan'] = $id_putusan;
		$list = M_putusan::daftar_dokumen($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','id_putusan','tambah','no','locus','list'));
	}
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$tambah=null;$data=null;
		
		$title = 'Tambah Putusan';
     	$main = 'be.m_putusan_add';
     	$arrLink=array(
				array("Putusan",route('m_putusan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_putusan.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		
		if(isset($id)){
			$paramsdt['id']=$id;
			$data = M_putusan::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
			$paramskat['id_putusan']=$id;
			$m_kajiankategori = M_putusan::daftar_kategori($paramskat);
		}
     	$params['table'] = 't_putusan';
     	$params['locus'] = session('be_uwilayah');
		$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		$listlaporan = M_laporan::daftardengannoreg($params);
		$paramskat1['level']=1;
		$m_kat1 = m_kajianakhir_kategori::daftar($paramskat1);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan','m_kat1'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$tambah=null;$data=null;
		$m_kajiankategori=null;
		
		$title = 'Tambah Putusan';
     	$main = 'be.m_putusan_view';
     	$arrLink=array(
				array("Putusan",route('m_putusan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_putusan/add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		
		$paramskat1['level']=1;
		if(isset($id)){
			$paramsdt['id']=$id;
			$data = M_putusan::daftar($paramsdt);
			if($data){
				if(!General::cekaksesview($data->locus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
			$paramskat['id_putusan']=$id;
			$m_kajiankategori = M_putusan::daftar_kategori($paramskat);
		}
		else{
			return redirect()->route('denied');
		}
        
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_kajiankategori'));
	}
	function add_dokumen($id_jenislaporan=null,$id_putusan = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_putusan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_putusan=$id_putusan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_putusan=dc($id_putusan);
		$id=dc($id);
		$tambah=null;$data=null;
		
		$paramsgetlap['id']=$id_putusan;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_putusan::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Dokumen Putusan <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_putusandok_add';
     	$arrLink=array(
				array("Putusan",route('m_putusan.index').'/'.$ec_id_jenislaporan),
				array("Dokumen",route('m_putusan.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan),
				);
		$tambah = 'href="'.route('m_putusan.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan.'"';
		$paramskat1['level']=1;
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_putusan::daftar_dokumen($params);
		}
        
		return view($main,compact('arrLink','title','id_jenislaporan','id_putusan','tambah','data','no','locus'));
	}
	function view_dokumen($id_jenislaporan=null,$id_putusan = NULL, $id=NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_putusan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_putusan=$id_putusan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_putusan=dc($id_putusan);
		$id=dc($id);
		$tambah=null;
		
		$paramsgetlap['id']=$id_putusan;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_putusan::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Dokumen Putusan <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_putusandok_view';
     	$arrLink=array(
				array("Putusan",route('m_putusan.index').'/'.$ec_id_jenislaporan),
				array("Dokumen",route('m_putusan.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan),
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_putusan.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_putusan.'"';
		}
		$paramskat1['level']=1;
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_putusan::daftar_dokumen($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_putusan','tambah','no','locus','data'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['note'] = getinp($request->note);
		$params['no'] = getinp($request->no);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		
		if($dt['operation']=='Ubah'){
			$datalap=DB::table("t_putusan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.no,b.locus,b.stsposisi')->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$stsposisi=$datalap->stsposisi;
				$ceklocus=$datalap->locus;
				
				if(General::cekaksesedit($ceklocus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			$datalap=DB::table("t_laporan")->selectRaw('no,locus,stsposisi')->where('id','=',$params['id_laporan'])->first();
            if(!empty($datalap)){
				$no=$datalap->no;
				$ceklocus=$datalap->locus;
				$cekstsposisi=$datalap->stsposisi;
				
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Putusan';
		M_laporan::setposisi($paramslaporan);
		
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_putusan::add($params);
		if($data){
			$id=$data;
		}
		$dokumen='';
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'putusan',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
			$dokumen=$namafile;
            $data=M_putusan::add($paramsupd);
		}
		if(isset($id)&&$dt['operation']=='Tambah'){
			$paramsdokumen['id_putusan'] = $id;
			$paramsdokumen['dokumen']=$dokumen;
			$paramsdokumen['no']=$params['no'];;
			$paramsdokumen['note']=$params['note'];
			$paramsdokumen['create_by'] =  session('be_uid');
			$paramsdokumen['create_date'] =  date("Y-m-d H:i:s");
			$data=M_putusan::add_dokumen($paramsdokumen);
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Putusan',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: ID:'.$id.', Title: Putusan dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_putusan.index').'/'.ec($id_jenislaporan);
	}
	function save_dokumen(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_putusan'] = getinp($request->id_putusan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_putusan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		$params['no'] = getinp($request->no);
		$params['note'] = getinp($request->note);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		
		$datalap=DB::table("t_putusan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$params['id_putusan'])
					 ->selectRaw('b.no,b.locus,b.stsposisi')->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(!General::cekaksesedit($ceklocus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_putusan::add_dokumen($params);
		$paramsupd['dokumen']=null;
		if($data){
			$id=$data;
		}
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'putusan',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_putusan::add_dokumen($paramsupd);
		}
		if(isset($id)){
			$paramsupdkajian['id'] = $params['id_putusan'];
			$paramsupdkajian['note'] = $params['note'];
			$paramsupdkajian['dokumen']=$paramsupd['dokumen'];
			$paramsupdkajian['edit_by'] =  session('be_uid');
			$paramsupdkajian['edit_date'] =  date("Y-m-d H:i:s");
			$data=M_putusan::add($paramsupdkajian);
		}
		
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Putusan:Dokumen',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: ID:'.$id.', Title: Putusan dengan pelaporan no '.$no.', dokumen '.$params['note'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_putusan.daftar_dokumen').'/'.ec($id_jenislaporan).'/'.ec($params['id_putusan']);
	}
	function del($id_jenislaporan=null,$id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table("t_putusan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->first();
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Putusan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: ID:'.$id.', Title: Putusan dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_putusan::del($id);
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		$params['stsposisi']='Pemeriksaan';
		M_laporan::add($params);
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Putusan',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		
		return redirect()->route('m_putusan.index',[$ec_id_jenislaporan]);
	}
	function del_dokumen($id_jenislaporan=null,$id_putusan=NULL, $id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id_putusan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_putusan=$id_putusan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$ec_id_putusan=$id_putusan;
		$id_putusan=dc($id_putusan);
		$id=dc($id);
		
		$datalap=DB::table("t_putusan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id_putusan)
					 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$dok_note=DB::table('t_putusan_dokumen')->select('note')->where('id',$id)->first()->note;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Putusan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: ID:'.$id.', Title: Putusan dengan pelaporan no '.$no.', dokumen '.$dok_note.' sudah dihapus ',
               'ip' => $request->ip()
           )
        );
		$data=M_putusan::del_dokumen($id);
		$doklast=DB::table('t_putusan_dokumen')->where('id_putusan',$id_putusan)->orderBy('id', 'desc')->first();
		if($doklast){
			$paramskajian['note']=$doklast->note;
			$paramskajian['dokumen']=$doklast->dokumen;
		}
		else{
			$paramskajian['note']=null;
			$paramskajian['dokumen']=null;
		}
		$paramskajian['id']=$id_putusan;
		$paramskajian['edit_by'] =  session('be_uid');
		$paramskajian['edit_date'] =  date("Y-m-d H:i:s");
		M_putusan::upd($paramskajian);
		
		return redirect()->route('m_putusan.daftar_dokumen',[$ec_id_jenislaporan,$ec_id_putusan]);
	}
}
