<?php

namespace App\Http\Controllers;

use DB;
use App\Models\User;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

use Illuminate\Mail\Mailable;
use Illuminate\Support\Facades\Mail;
	
class M_PelaporController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Pelapor",route('m_pelapor.index'))
		);
		$title='Daftar Pelapor';
		$tambah = 'href="'.route('m_pelapor.add').'"';
		return view('be.m_pelapor_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Pelapor';
		$arrLink=array(
				array("Pelapor",route('m_user.index'))
				);
		$params['id'] =$id;
		$m_provinsi=DB::table('m_provinsi')->get();
		$m_pekerjaan=DB::table('m_pekerjaan')->get();
		$m_katpelapor=DB::table('m_katpelapor')->get();
		$m_jenis_noidentitas=DB::table('m_jenisnoidentitas')->get();
		$data=null;
		$m_kabkota=null;
		$m_kappelapor=null;
		if(isset($id)){
			$data=User::daftar($params);
			if($data){
				$m_kabkota=DB::table('m_kabkota')->whereRaw("substring(kode,1,2)='".substr($data->provinsi,0,2)."'")->get();;
				$m_kappelapor=DB::table('m_kappelapor')->where("id_katpelapor","=",$data->id_katpelapor)->get();
			}
		}
		return view('be.m_pelapor_add',compact('arrLink','operation','title','data','m_provinsi','m_pekerjaan','m_katpelapor','m_jenis_noidentitas','m_kabkota','m_kappelapor'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Pelapor';
		$arrLink=array(
				array("Periode",route('m_periode.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=User::daftar($params);
		}
		return view('be.m_pelapor_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['nm_user'] = getinpb($request->nm_user);
		$params['sandi'] = getinpb($request->sandi);
		$params['jenis_noidentitas'] = getinp($request->jenis_noidentitas);
		$params['no_identitas'] = getinp($request->no_identitas);
		$params['id_katpelapor'] = getinp($request->id_katpelapor);
		$params['id_kappelapor'] = getinp($request->id_kappelapor);
		$params['kappelapor'] = getinp($request->kappelapor);
		$params['tempat_lahir'] = getinp($request->tempat_lahir);
		$params['tanggal_lahir'] = getinp($request->tanggal_lahir);
		$params['jenis_kelamin'] = getinp($request->jenis_kelamin);
		$params['pekerjaan'] = getinp($request->pekerjaan);
		$params['pekerjaan_lain'] = getinp($request->pekerjaan_lain);
		$params['jabatan'] = getinp($request->jabatan);
		$params['warganegara'] = getinp($request->warganegara);
		$params['alamat'] = getinp($request->alamat);
		$params['provinsi'] = getinp($request->provinsi);
		$params['kabkota'] = getinp($request->kabkota);
		$params['hp'] = getinp($request->hp);
		$params['fax'] = getinp($request->fax);
		$params['email'] = getinp($request->email);
		$params['id_jenislaporan'] = getinp($request->id_jenislaporan);
		
		if($params['id_katpelapor']==1||$params['id_katpelapor']==2){
			$params['kappelapor']=null;
		}
		elseif($params['id_katpelapor']==3||$params['id_katpelapor']==4){
			$params['id_kappelapor']=null;
		}
		else{
			$params['kappelapor']=null;
			$params['id_kappelapor']=null;
		}
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Tambah'){
			$stsaksi=1;
			$cek=User::cekadd($params);
			if($cek!=''){
				return redirect()->route('m_pelapor.add')->with('failed', 'Username sudah terdaftar');
			}
			$params['locus_daftar'] =session('be_uwilayah');
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$stsaksi=2;
			$params['nm_user'] =null;
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		if(isset($params['kabkota'])){
			$params['wilayah']=$params['kabkota'];
		}
		elseif(isset($params['provinsi'])){
			$params['wilayah']=$params['provinsi'];
		}
		else{
			$params['wilayah']='0';
		}
		if($id==''){$id=null;}
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=User::add($params);
			
			if($dt['operation']=='Tambah'){
				ssobaru_user_create($params['nm_user'],$params['sandi'],$params['nama']);
				$id=$data;
				if($params['email']!=""){
					$paramsemail['toemail']=$params['email'];
					$paramsemail['subyek']='Permohonan registrasi SIGAPLapor sedang diproses';
					$paramsemail['pesan']='Terimakasih sudah mendaftar di Sigap Lapor Bawaslu.<br><br>Permohonan pendaftaran sedang kami proses dan akan kami beritahukan lebih lanjut.';
					kirim_email($paramsemail);
				}
				if($params['hp']!=""){
					$hp=$params['hp'];
					$hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
					//$WhatsappService=new WhatsappService;
					//$WhatsappService->sendMessageToWhatsapp($hp, 'Terimakasih sudah mendaftar di SIGAPLapor Bawaslu.Permohonan pendaftaran sedang kami proses dan akan kami beritahukan lebih lanjut. note:jangan reply ke no wa ini.');
				}
			}
			else{
				$nm_user=getinpb($request->nm_user);
				if($nm_user!=NULL&&$params['sandi']!=NULL){
					//reset_password_ssobaru($nm_user,$params['sandi']);
				}
			}
			
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: Pelapor '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_pelapor.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function add_ajax_katpelapor($id)
	{
		$query = DB::table('m_kappelapor')->where("id_katpelapor","=","$id")->get();
    	$data = "<option value=''>- Pilih -</option>";
    	foreach ($query as $value) {
        	$data .= "<option value='".$value->id."'>".$value->nama."</option>";
    	}
    	echo $data;
	}
	function cekuser(Request $request){
		$params['nm_user'] = getinp($request->u);
		$cek=User::cekadd($params);
		//$cek_sso=get_userid_ssobaru($params['nm_user']);
		if(!$cek==''){
			echo -1;
		}
	}
	function cekuser1(Request $request){
		$params['nm_user'] = getinp($request->u);
		$cek=cek_userid_ssobaru($params['nm_user']);
		if($cek==''){
			echo -1;
		}
	}
	function save_notif(Request $request){
		$id_pelapor = getinp($request->id_pelapor);
		$notif = getinp($request->notif);
		if(!cekint($id_pelapor)){
			return redirect()->route('denied');
		}
		if($id_pelapor!=""&&$notif!=""){
			$data=DB::table('t_user')->select('hp,email,nama')->where('id_user','=',$id_pelapor)->first();
			$hp=$data->hp;
			$email=$data->email;
			$nama=$data->nama;
			if($hp!=""){
				$hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
				//$WhatsappService=new WhatsappService;
				//$WhatsappService->sendMessageToWhatsapp($hp, $notif);
			}
			if($email!=""){
				$paramsemail['toemail']=$email;
				$paramsemail['subyek']='Notifikasi dari SIGAPLapor Bawaslu';
				$paramsemail['pesan']=$notif;
				//kirim_email($paramsemail);
			}
			$paramsnotif['pesan']=$notif;
			$paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
			$paramsnotif['id_user']=$id_pelapor;
			$res=M_notifikasi::add($paramsnotif);
		}
		
		echo 1;
	}
	function list_result(Request $request):JsonResponse
	{
		//if($request->ajax()){
			$params['locus'] = session('be_uwilayah');
			$collection = User::daftar($params);
			return DataTables::of($collection)
			->addColumn('id_user_ec', function ($arrData){
				return ec($arrData->id_user);
			})
			->addColumn('identitas', function ($arrData){
				return $arrData->jenis_noidentitasnm.' '.$arrData->no_identitas;
			})
			->addColumn('alamatdetail', function ($arrData){
				return $arrData->alamat.(isset($arrData->kabkotanm)?', '.$arrData->kabkotanm:'').(isset($arrData->kabkotanm)?', '.$arrData->provinsinm:'');
			})
			->addColumn('submenu_katasandi', function ($arrData){
				$sts='0';
				if(session('be_uwilayah')=='0'||session('be_urole')==3||($arrData->wilayah==session('be_uwilayah')&&session('be_urole')==1)){
					$sts='1';
				}
				return $sts;
			})
			->addColumn('submenu_ubah', function ($arrData){
				$sts='0';
				if($arrData->wilayah==session('be_uwilayah')||session('be_urole')==3){
					$sts='1';
				}
				return $sts;
			})
			->make(true);
		//}
    }
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from t_laporan where id_pelapor=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_user.index')->with('failed', 'Pelapor sudah pernah membuat laporan. Hapus Data Pelapor Tidak Berhasil');
		}
		else{
			$str="select nama from t_user where id_user=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: Pelapor '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			User::del($id);
			return redirect()->route('m_pelapor.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function aktivasi(Request $request){
		$params['id'] = getinp($request->id);
		$params['aktif'] = getinp($request->aktif);
		
		if($params['id']!=""){
			if($params['aktif']==1){
				$params['aktif']=0;
				$params['stsvalid_by']=session('be_uid');
				$params['stsvalid_date']=date("Y-m-d H:i:s");
	     		User::add($params);
				return redirect()->route('m_pelapor.index')->with('success', 'Pelapor sudah diset tidak aktif');
			}
			else{
				$params['aktif']=1;
	     		User::add($params);
				return redirect()->route('m_pelapor.index')->with('success', 'Aktivasi Data Berhasil');
			}
		}
	}
	function test(){
		$mailable = new Mailable();
        $mailable
            ->from('ismailkalisari@example.com')
            ->to('ismailkalisari@example.com')
            ->subject('test subject')
            ->html('my first message');
        $result = Mail::send($mailable);
        return true;
	}
}
