<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_LogController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Log",route('m_log.index'))
		);
		$title='Daftar Log';
		$main='be.m_log_list';
		return view($main,compact('arrLink','title'));
    }
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$collection =DB::table('t_log as a')
						->leftJoin("t_user as b","b.id_user","=","a.id_user")
						->leftJoin("m_user as c","c.id_user","=","a.id_user")
						->selectRaw("note,modul,aksi,a.id_user,tgl,ip,
						(case 
						when a.stsfrom=1 then b.nama
						when a.stsfrom=2 then c.nama
						end) nama");
			return DataTables::of($collection)
			->addColumn('tgl', function ($arrData){
				$s=konversi_tanggal("d/m/Y",$arrData->tgl);
				return $s;
			})
			->addColumn('tglnm', function ($arrData){
				$s=konversi_tanggal('j M Y',$arrData->tgl);
				return $s;
			})
			->addColumn('modul', function ($arrData){
				return $arrData->modul;
			})
			->addColumn('aksi', function ($arrData){
				return $arrData->aksi;
			})
			->addColumn('note', function ($arrData){
				return $arrData->note;
			})
			->addColumn('nama', function ($arrData){
				return $arrData->nama;
			})
			->addColumn('ip', function ($arrData){
				return $arrData->ip;
			})
			->make(true);
		}
    }
}
