<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_libur;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_LiburController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Libur",route('m_libur.index'))
		);
		$title='Daftar Hari Libur';
		$tambah = 'href="'.route('m_libur.add').'"';
		$generate = 'href="'.route('m_libur.gen').'"';
		return view('be.m_libur_list',compact('arrLink','title','tambah','generate'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Hari Libur';
		$arrLink=array(
				array("Libur",route('m_user.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_libur::daftar($params);
		}
		return view('be.m_libur_add',compact('arrLink','operation','title','data'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Hari Libur';
		$arrLink=array(
				array("Libur",route('m_libur.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_libur::daftar($params);
		}
		return view('be.m_libur_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['tanggal'] = getinp($request->tanggal);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_libur::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_libur.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select nama from m_libur where id=".$id." limit 1";
		$nama=DB::select($str)[0]->nama;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'User',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: libur '.$nama.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		M_libur::del($id);
		return redirect()->route('m_libur.index')->with('success', 'Hapus Data Berhasil');
	}
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$str="select id,nama,tanggal from m_libur";
			$collection = DB::select($str);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('tanggal', function ($arrData){
				return konversi_tanggal('j M Y',$arrData->tanggal);
			})
			->make(true);
		}
    }
	function gen($id = NULL){
		$operation = 'Generate';
		$title = $operation.' Hari Libur';
		$arrLink=array(
				array("Libur",route('m_libur.index'))
				);
		return view('be.m_libur_gen',compact('arrLink','operation','title'));
	}
	function gens(Request $request){
		$tahun = $request->tahun;
		//$tahun=2022;
		$url="https://api-harilibur.vercel.app/api?year=".$tahun;
		$get_url = file_get_contents($url);
		$data=array();
		$data = json_decode($get_url);
		DB::select('delete from m_libur where year(tanggal)='.$tahun);
		foreach($data as $item){
			if($item->is_national_holiday){
				$res=new M_libur;
				$res->nama=$item->holiday_name;
				$res->tanggal=$item->holiday_date;
				$res->save();
			}
		}
		return redirect()->route('m_libur.index')->with('success', 'Import Data Hari Libur Berhasil');
	}
}
