<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_notifikasi;
use App\Models\M_notifikasia;
use App\Models\User;
use App\Models\Nomor;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_LaporanController extends Controller
{ 
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $jdl='';
        if($id_jenislaporan==1){
            $jdl='Pemilihan';
        }
        elseif($id_jenislaporan==2){
            $jdl='Pemilu';
        }
        elseif($id_jenislaporan==3){
            $jdl='Administrasi Pemilu';
        }
		$arrLink=array(
			array("Pelaporan",route('m_laporan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Pelaporan Pelanggaran '.$jdl;
		$tambah = 'href="'.route('m_laporan.add').'/'.$ec_id_jenislaporan.'"';
		
		$params['locus'] = session('be_uwilayah');
		$params['id_jenislaporan'] = $id_jenislaporan;
		$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->first()->id;
		$list = M_laporan::daftar_index($params);
		
		return view('be.m_laporan_list',compact('arrLink','title','tambah','ec_id_jenislaporan','list'));
    }
	public function noed($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $jdl='';
        if($id_jenislaporan==1){
            $jdl='Pemilihan';
        }
        elseif($id_jenislaporan==2){
            $jdl='Pemilu';
        }
        elseif($id_jenislaporan==3){
            $jdl='Administrasi Pemilu';
        }
		$arrLink=array(
			array("Pelaporan",route('m_laporan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Pelaporan Pelanggaran '.$jdl;
		$tambah = 'href="'.route('m_laporan.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_laporan_noed',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_laporan::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('nolaporan', function ($arrData){
				$s=$arrData->no.'<div></div>';
				$s.='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_laporan.mview').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>';
                          if (session('be_urole')!=4){
                              if($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
                                  $s.='<li>
                                      <a class="dropdown-item btn-sm" href="'.route('m_laporan.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-edit"></i> Ubah</a>
                                  </li>';
                                  if($arrData->stsposisi=="Input Pelaporan"||$arrData->stsposisi=="Konfirmasi Pelaporan"){
                                         $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_laporan.mvalidasi').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'>"><i class=" ti-write"></i> Validasi Laporan</a></li>';
                                  }
                                  if(session('be_urole')==3){
                                         $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_laporan.mtahapan').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class=" ti-write"></i> Ubah Tahapan</a></li>';
                                  }
                                  $s.='<li class="dropdown-submenu dropdown-submenu-left">
                                      <a class="dropdown-item dropdown-toggle" href="#"><i class=" ti-printer"></i> Cetak</a>
                                      <ul class="dropdown-menu first-sub-menu">
                                          <li><a class="dropdown-item btn-sm" href=javascript:cetak("'.route('m_laporan.cetak_prn').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'")><i class="  ti-printer"></i> Cetak Laporan</a></li>
                                          <li><a class="dropdown-item btn-sm" href="javascript:cetak("'.route('m_laporan.cetak_mod3').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'")><i class="  ti-printer"></i> Cetak <?php echo $id_jenislaporaninit?>.3</a></li>
                                          <li><a class="dropdown-item btn-sm" href=javascript:cetak("'.route('m_laporan.cetak_mod31').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'")><i class="  ti-printer"></i> Cetak <?php echo $id_jenislaporaninit?>.3.1</a></li>
                                      </ul>
                                  </li>';
                                  if($arrData->stsposisi=="Input Pelaporan"||$arrData->stsposisi=="Konfirmasi Pelaporan"){
                                      $s.='<li><a class="dropdown-item btn-sm item_delete"  data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                                  }
                                  if(session('be_uid')==1041||session('be_urole')==3){
                                      $s.='<li><a class="dropdown-item btn-sm item_delete_allsm"  data-id="'. ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus Semua</a></li>';
                                  }
                              }
                          }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->addColumn('waktukejadian', function ($arrData){
				return konversi_tanggal('d-M-Y',$arrData->waktukejadian).' '.$arrData->waktukejadian_time;
			})
			->make(true);
		//}
    }
	function list_result_noed($id_jenislaporan=null,Request $request):JsonResponse
	{
		if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_laporan::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('waktukejadian', function ($arrData){
				return konversi_tanggal('d-M-Y',$arrData->waktukejadian).' '.$arrData->waktukejadian_time;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      	<ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_laporan.mview').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
                         </ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		}
    }
	public function unreg($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $jdl='';
        if($id_jenislaporan==1){
            $jdl='Pemilihan';
        }
        elseif($id_jenislaporan==2){
            $jdl='Pemilu';
        }
        elseif($id_jenislaporan==3){
            $jdl='Administrasi Pemilu';
        }
		$arrLink=array(
			array("Pelaporan",route('m_laporan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Pelaporan Pelanggaran Unregistered '.$jdl;
		return view('be.m_laporan_unreg',compact('arrLink','title','ec_id_jenislaporan'));
    }
	function list_result_unreg($id_jenislaporan=null,Request $request):JsonResponse
	{
		if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_laporan::daftar_unreg($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('waktukejadian', function ($arrData){
				return konversi_tanggal('d-M-Y',$arrData->waktukejadian).' '.$arrData->waktukejadian_time;
			})
			->make(true);
		}
    }
    function save_no(Request $request){
        $sts="";
        $params['id']=getinp($request->id);
        $params['no']=getinp($request->no);
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        if($params['id']!=""){
            $no="1";
            $data_no=M_laporan::select('no')->where("id","=",$params['id'])->first();
			if($data_no){
                $no=$data_no->no;
            }
            $data=M_laporan::updno($params);
            if($data){
                $sts="1";
                M_log::add(
		           array(
		               'stsfrom' => 2,
		               'modul' => 'Laporan',
		               'aksi' => "Ubah",
		               'note' => 'ID:'.$params['id'].', Title: Ubah no laporan '.$no.' menjadi '.$params['no'],
		               'ip' => $request->ip()
		           )
		        );
            }
        }
        echo $sts;
    }
    function save_reg(Request $request){
        $sts="";
        $params['id']=getinp($request->id);
        $params['reg']=getinp($request->reg);
        $params['reg2']=getinp($request->reg2);
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        if($params['id']!=""){
            $no="";
            $data_no=M_laporan::select('no_registrasi')->where("id","=",$params['id'])->first();
            if($data_no){
                $no=$data_no->no_registrasi;
            }
            $data=M_laporan::updreg($params);
            if($data){
                $sts="1";
                M_log::add(
		           array(
		               'stsfrom' => 2,
		               'modul' => 'Laporan',
		               'aksi' => "Ubah",
		               'note' => 'ID:'.$params['id'].', Title: Ubah no registrasi laporan '.$no.' menjadi '.$params['reg'],
		               'ip' => $request->ip()
		           )
		        );
            }
        }
        echo $sts;
    }
    function add($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
		$m_wilkabkota=null;
		$kode_kab=null;
		$m_wilkecamatan=null;
		$m_kejadiankabkota=null;
		$kode_kab=null;
		$m_wilkecamatan=null;
		$m_jenispemilihan=null;
		$m_pelaporlain=null;
		$m_terlapor=null;
		$m_saksi=null;
		$m_bukti=null;
		$m_petitum=null;
		$jenistempatkejadian=null;
		$kode_kab=null;
		$m_kecamatan=null;
		$usernegara=null;
		$m_kejadiankecamatan=null;
		$data=null;
        if(isset($id)){
            $paramsa['id']=$id;
            $data= M_laporan::daftara($paramsa);
            if(!empty($data)){
                $ceklocus=$data->locus;
                $stsposisi=$data->stsposisi;
                $id_jenislaporan=$data->id_jenislaporan;
                
                if($data->wilprovinsi!=""){
					$m_wilkabkota=DB::table('m_kabkota')->whereRaw("substring(kode,1,2)='".substr($data->wilprovinsi,0,2)."'")->get();
                }
                if($data->wilkabkota!=""){
					$kode_kab=DB::table('w_kabupaten')->select('kode')->where("m_kabkota_kode","=",$data->wilkabkota)->get();
					$m_wilkecamatan=DB::table('w_kecamatan')->whereRaw("LEFT(kode,5)='".$kode_kab[0]->kode."'")->get();
                }
                if($data->kejadianprovinsi!=""){
					$m_kejadiankabkota=DB::table('m_kabkota')->whereRaw("substring(kode,1,2)='".substr($data->kejadianprovinsi,0,2)."'")->get();
                }
                if($data->kejadiankabkota!=""){
					$kode_kab=DB::table('w_kabupaten')->select('kode')->where("m_kabkota_kode","=",$data->kejadiankabkota)->get();
					$m_kejadiankecamatan=DB::table('w_kecamatan')->whereRaw("LEFT(kode,5)='".$kode_kab[0]->kode."'")->get();
                }
                $m_jenispemilihan =self::cmadd_ajax_jenispemilihan($data->id_jenislaporan,$data->wilayah,$data->id_jenispemilihan);
				$m_pelaporlain=DB::table('t_pelaporlain')->where('id_laporan','=',$id)->get();
				$m_terlapor=DB::table('t_terlapor')->where('id_laporan','=',$id)->get();
				$m_saksi=DB::table('t_saksi')->where('id_laporan','=',$id)->get();
				$m_bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->get();
				$m_petitum=DB::table('t_petitum')->where('id_laporan','=',$id)->get();
                $jenistempatkejadian=$data->jenistempatkejadian;
            }
            else{
                return redirect()->route('denied');
            }
        }
        
        if(session('be_uwilayah')==0){
        } elseif(substr(session('be_uwilayah'),3,2)=='00') {
        } else {
            if(session('be_uposisi')==1){
				$kode_kab=DB::table('w_kabupaten')->select('kode')->where("m_kabkota_kode","=",session('be_uwilayah'))->get();
				$m_kecamatan=DB::table('w_kecamatan')->whereRaw("LEFT(kode,5)=".$kode_kab[0]->kode)->get();
            }
        }
        
        if($id_jenislaporan==1){
            if(substr(session('be_uwilayah'),3,2)=='00'){
                $params['provinsi']=session('be_uprovinsi');
            }
            else{
                if(session('be_uwilayah')!='0'){
                    $params['kabkota']=session('be_ukabkota');
                }
            }
        }
        $jdl='';
        if($id_jenislaporan==1){
            $jdl='Pemilihan';
        }
        elseif($id_jenislaporan==2){
            $jdl='Pemilu';
        }
        elseif($id_jenislaporan==3){
            $jdl='Administrasi Pemilu';
        }
        $title = 'Pelaporan Pelanggaran '.$jdl;
        $main = 'm_laporan_add';
        $id_jenislaporan=$id_jenislaporan;
        
		$m_provinsi = DB::table("m_provinsi")->get();
		$m_negara = DB::table("m_negara")->get();
		
        if (session('be_uposisi')==2) {
			$usernegara=DB::table("m_negara")->where('kode','=',session('be_uwilayah'))->get()[0]->nama;
        }
        $params['aktif']=1;
        $listpelapor = User::daftar($params);
		
		$arrLink=array(
			array("Pelaporan",route('m_laporan.index').'/'.$ec_id_jenislaporan)
		);
		return view('be.m_laporan_add',compact('arrLink','title','ec_id_jenislaporan','id_jenislaporan','m_wilkabkota','m_wilkecamatan','m_kejadiankabkota','m_kejadiankecamatan','m_jenispemilihan','m_pelaporlain','m_terlapor','m_saksi','m_bukti','m_petitum','jenistempatkejadian','m_kecamatan','m_provinsi','m_negara','usernegara','listpelapor','data'));
    }
    function madd_ajax_jenispemilihan($id=null,$kd=null)
    {
        $data = "<option value=''>- Pilih Kategori -</option>";
        if($id==1){
            if(substr(session('be_uwilayah'),0,2)==substr($kd,0,2)){
                $data .= "<option value='1'>Pemilihan Gubernur/Wakil Gubernur</option>";
                $data .= "<option value='2'>Pemilihan Bupati/Wakil Bupati</option>";
                $data .= "<option value='3'>Pemilihan Walikota/Wakil Walikota</option>";
            }
            if(session('be_uwilayah')=='0'){
                $data .= "<option value='1'>Pemilihan Gubernur/Wakil Gubernur</option>";
                $data .= "<option value='2'>Pemilihan Bupati/Wakil Bupati</option>";
                $data .= "<option value='3'>Pemilihan Walikota/Wakil Walikota</option>";
            }
        }
        elseif($id==2||$id==3){
            $query=DB::table("m_jenispemilihan")->where('id_jenislaporan','=',$id)->get();
            foreach ($query->result() as $value) {
                $data .= "<option value='".$value->id."'>".$value->nama."</option>";
            }
        }
        echo $data;
    }
    function cmadd_ajax_jenispemilihan($id=null,$kd=null,$id_jenispemilihan=null)
    {
        $data='';
        if($id==1){
            if(substr(session('be_uwilayah'),0,2)==substr($kd,0,2)){
                $data .= "<option value='1' ".($id_jenispemilihan==1?"selected":"").">Pemilihan Gubernur/Wakil Gubernur</option>";
                $data .= "<option value='2' ".($id_jenispemilihan==2?"selected":"").">Pemilihan Bupati/Wakil Bupati</option>";
                $data .= "<option value='3' ".($id_jenispemilihan==3?"selected":"").">Pemilihan Walikota/Wakil Walikota</option>";
            }
            if(session('be_uwilayah')=='0'){
                $data .= "<option value='1' ".($id_jenispemilihan==1?"selected":"").">Pemilihan Gubernur/Wakil Gubernur</option>";
                $data .= "<option value='2' ".($id_jenispemilihan==2?"selected":"").">Pemilihan Bupati/Wakil Bupati</option>";
                $data .= "<option value='3' ".($id_jenispemilihan==3?"selected":"").">Pemilihan Walikota/Wakil Walikota</option>";
            }
        }
        elseif($id==2||$id==3){
            $query=DB::table("m_jenispemilihan")->where("id_jenislaporan","=",getinp($id))->get();
            foreach ($query as $value) {
                $data .= "<option value='".$value->id."' ".($id_jenispemilihan==$value->id?"selected":"").">".$value->nama."</option>";
            }
        }
        return $data;
    }
	function save(Request $request){
        $stskirimemail=0;
        $id = getinp($request->id);
        $no = getinp($request->no);
        $params['no_offline'] = getinp($request->no_offline);
        $locusasli = getinp($request->locus);
        $params['id'] =$id;
		$params['id_periode'] = DB::table('m_periode')->where('aktif','=',1)->first()->id;
        $params['id_pelapor'] = getinp($request->id_pelapor);
        if(!isset($params['id_pelapor'])){
            return redirect()->route('be');
            die();
        }
        $id_katpelapor = getinp($request->id_katpelapor);
        $params['id_jenispemilihan'] = getinp($request->id_jenispemilihan);
        $params['ststsm'] = getinp($request->ststsm);
        $params['id_jenislaporan'] = getinp($request->id_jenislaporan);
        $uprovinsi=getinp($request->wilprovinsia);
        $ukabkota=getinp($request->wilkabkotaa);

        if ($request->kecamatan!= null) {
            $params['kecamatan'] = getinp($request->kecamatan);
        }
        
        if($params['id_jenispemilihan']==1){
            $params['wilprovinsi'] =$uprovinsi;
            $params['wilkabkota'] = null;
        }
        elseif($params['id_jenispemilihan']==2||$params['id_jenispemilihan']==3){
            $params['wilprovinsi'] =$uprovinsi;
            $params['wilkabkota'] = $ukabkota;
        }
        elseif($params['id_jenispemilihan']==7){
            $params['wilprovinsi'] = getinp($request->wilprovinsi);
            $params['wilkabkota'] = getinp($request->wilkabkota);
            $params['wilkecamatan'] = getinp($request->wilkecamatan);
        } else{
            $params['wilprovinsi'] = getinp($request->wilprovinsi);
            $params['wilkabkota'] = getinp($request->wilkabkota);
        }
        
        $params['waktukejadian'] = getinp($request->waktukejadian);
        $params['waktukejadian_jam'] = getinp($request->waktukejadian_jam);
        $params['waktukejadian_menit'] = getinp($request->waktukejadian_menit);
        $params['waktukejadian_time']='';
        if($params['waktukejadian']!=""){
            if($params['waktukejadian_jam']!=""||$params['waktukejadian_menit']!=''){
                if($params['waktukejadian_jam']!=""){
                    $params['waktukejadian_time']=str_repeat('0',2-strlen($params['waktukejadian_jam'])).$params['waktukejadian_jam'];
                }
                else{
                    $params['waktukejadian_time']='00';
                }
                if($params['waktukejadian_menit']!=""){
                    $params['waktukejadian_time']=$params['waktukejadian_time'].':'.str_repeat('0',2-strlen($params['waktukejadian_menit'])).$params['waktukejadian_menit'];
                }
                else{
                    $params['waktukejadian_time']=$params['waktukejadian_time'].':00';
                }
            }
        }
        else{
            $params['waktukejadian']="";
            $params['waktukejadian_jam'] ="";
            $params['waktukejadian_menit'] ="";
            $params['waktukejadian_time']="";
        }
        $params['waktudiketahui'] = getinp($request->waktudiketahui);
        $params['waktudiketahui_jam'] = getinp($request->waktudiketahui_jam);
        $params['waktudiketahui_menit'] = getinp($request->waktudiketahui_menit);
        $params['waktudiketahui_time']='';
        if($params['waktudiketahui_jam']!=""||$params['waktudiketahui_menit']!=''){
            if($params['waktudiketahui_jam']!=""){
                $params['waktudiketahui_time']=str_repeat('0',2-strlen($params['waktudiketahui_jam'])).$params['waktudiketahui_jam'];
            }
            else{
                $params['waktudiketahui_time']='00';
            }
            if($params['waktudiketahui_menit']!=""){
                $params['waktudiketahui_time']=$params['waktudiketahui_time'].':'.str_repeat('0',2-strlen($params['waktudiketahui_menit'])).$params['waktudiketahui_menit'];
            }
            else{
                $params['waktudiketahui_time']=$params['waktudiketahui_time'].':00';
            }
        }
        $params['tgl_offline'] = getinp($request->tgl_offline);
        //$params['waktukejadian']=getinp($params['waktukejadian']);
        //$params['waktudiketahui']=getinp($params['waktudiketahui']);
        //$params['tgl_offline']=getinp($params['tgl_offline']);
        $params['ringkasan'] = getinp($request->ringkasan);
        $params['uraian'] = getinpc($request->uraian);
        $params['kejadiankabkotabb'] = getinp($request->kejadiankabkotabb);
        $params['jenistempatkejadian'] = getinp($request->jenistempatkejadian);
        if($params['id_jenislaporan']==1){
            $params['jenistempatkejadian']="Dalam Negeri";
        }
        
        if($params['id_jenislaporan']==2||$params['id_jenislaporan']==3){
            if($params['jenistempatkejadian']=="Dalam Negeri"){
                $params['kejadianprovinsi'] = getinp($request->kejadianprovinsi);
                $params['kejadiankabkota'] = getinp($request->kejadiankabkota);
                $params['kejadiankecamatan'] = getinp($request->kejadiankecamatan);
                $params['kejadianalamat'] = getinp($request->kejadianalamat);
                if(isset($params['kejadiankabkota'])){
                    $params['locus']=session('be_uwilayah');
                }
                else{
                    $params['locus']=session('be_uwilayah');
                }
            }
            else{
                $params['locus']=session('be_uwilayah');
                $params['kejadianprovinsi'] = NULL;
                $params['kejadiankabkota'] = NULL;
                $params['jenistempatkejadian']="Luar Negeri";
                $params['kejadianalamat'] = getinp($request->kejadianalamata);
                $params['kejadiannegara'] = getinp($request->kejadiannegara);
            }
        }
        else{
            if($params['id_jenispemilihan']==1){
                $params['locus']=session('be_uwilayah');
                $params['kejadianprovinsi'] = $uprovinsi;
                $params['kejadiankabkota'] = $params['kejadiankabkotabb'];
                $params['kejadianalamat'] = getinp($request->kejadianalamat);
                if($params['ststsm']==1){
                    $params['locus']=substr(session('be_uwilayah'),0,2).'.00';
                }
            }
            elseif($params['id_jenispemilihan']==2||$params['id_jenispemilihan']==3){
                $params['locus']=session('be_uwilayah');
                $params['kejadianprovinsi'] = $uprovinsi;
                $params['kejadiankabkota'] = $ukabkota;
                $params['kejadianalamat'] = getinp($request->kejadianalamat);
                if($params['ststsm']==1){
                    $params['locus']=substr(session('be_uwilayah'),0,2).'.00';
                }
            }
        }
        $dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
        if(!isset($params['locus'])){
            return redirect()->route('be');
            die();
        }
        $locus=$params['locus'];
        if($dt['operation']=='Tambah') {
            $no='';
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
            
            if($id_katpelapor==4){
                $jenislaporan='TM';
            }
            else{
                $jenislaporan='LP';
            }
            $jenispemilu=Nomor::getjenispemilu($params['id_jenispemilihan']);
            
            if($params['jenistempatkejadian']=="Dalam Negeri") {
                if ($request->kecamatan != null) {
                    $urut=Nomor::getnourut($request->kecamatan, $params['locus'], $jenislaporan, $jenispemilu);
                } else {
                    $urut=Nomor::getnourut('', $params['locus'], $jenislaporan, $jenispemilu);
                }
            } else {
                $urut=Nomor::getnourutluarnegeri($params['kejadiannegara'], $jenislaporan, $jenispemilu);
            }
            $kodepengawas=Nomor::getkodepengawas($params['jenistempatkejadian'],$params['locus'],getinp($request->kejadiannegara));
            $bulantahun=Nomor::getkodebulantahun(0,$request->tgl_offline);
            if ($params['jenistempatkejadian']=='Dalam Negeri') {
                if ($request->kecamatan != null) {
                    $kodepengawas='Kec-'.$request->kecamatan.'/'.$params['locus'];
                }
            }
            $no=$urut.'/'.$jenislaporan.'/'.$jenispemilu.'/'.$kodepengawas.'/'.$bulantahun;
            $params['no']=$no; // INI UTK UPDATE NO LAPORAN
            $params['stsposisi']='Input Pelaporan';
            $params['stsdibuat']=2; //offline
        }
        else{
            $params['locus']=$locusasli;
            
            if(session('be_urole')==3){
                if($id_katpelapor==4){
                    $jenislaporan='TM';
                }
                else{
                    $jenislaporan='LP';
                }
                $jenispemilu=Nomor::getjenispemilu($params['id_jenispemilihan']);
                $kodepengawas=Nomor::getkodepengawas($params['jenistempatkejadian'],$params['locus'],$request->kejadiannegara);
                
                if($no!=""){
                    $arr_no=explode("/",$no);
                    if($arr_no[1]==$jenislaporan&&$arr_no[2]==$jenispemilu&&$arr_no[3]."/".$arr_no[4]==$kodepengawas){
                    }
                    else{
                        if ($request->kecamatan != null) {
                            $kodepengawas='Kec-'.$request->kecamatan.'/'.$params['locus'];
                        }
                        $no1=$arr_no[0].'/'.$jenislaporan.'/'.$jenispemilu.'/'.$kodepengawas.'/'.$arr_no[5]."/".$arr_no[6];
                        $params['no']=$no1;
                    }
                }
            }
            
            if(!cekint($id)){redirect()->route('be');die();}
            $datalap=DB::table('t_laporan')->selectRaw('locus,stsposisi')->where('id','=',$id)->limit(1)->first();
			if(!empty($datalap)){
                $ceklocus=$datalap->locus;
                $cekstsposisi=$datalap->stsposisi;
                if(General::cekaksesedit($ceklocus)&&($cekstsposisi=='Input Pelaporan'||session('be_urole')==3)){
                }
                else{
                    //redirect('denied');
                }
            }
            else{
                redirect()->route('be');die();
            }
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_laporan::add($params);
        if($dt['operation']=='Tambah'){
            $id=$data;
            
            //notifikasi ke pelapor
            $paramsnotif['pesan']='Silakan cetak dokumen pelaporan '.$no.' dan bawa serta ke bawaslu terkait berikut dokumen lainnya dan bukti-bukti yang diperlukan paling lambat 2x24 jam hari kerja';
            $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
            $paramsnotif['id_user']=$params['id_pelapor'];
            $data=M_notifikasi::add($paramsnotif);
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => "Ubah",
               'note' => 'ID:'.$params['id'].', Title: No Laporan: '.$no,
               'ip' => $request->ip()
           )
        );
		
        $pelaporlain_nama=$request->pelaporlain_nama;
        $pelaporlain_alamat=$request->pelaporlain_alamat;
        $pelaporlain_provinsi=$request->pelaporlain_provinsi;
        $pelaporlain_kabkota=$request->pelaporlain_kabkota;
        $pelaporlain_hp=$request->pelaporlain_hp;
        
        $index = 0;
        $urut=1;
        $data_pelaporlain = array();
        if(isset($pelaporlain_nama)){
            foreach($pelaporlain_nama as $item){
                if($item!=''){
                    array_push($data_pelaporlain, array(
                    'urut'=>$urut,
                    'id_laporan'=>getinpb($id),
                    'nama'=>getinpb($item),
                    'alamat'=>getinpb($pelaporlain_alamat[$index]),
                    'provinsi'=>getinpb($pelaporlain_provinsi[$index]),
                    'kabkota'=>getinpb($pelaporlain_kabkota[$index]),
                    'hp'=>getinpb($pelaporlain_hp[$index]),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params1['id_laporan'] = $id;
            $data1=M_laporan::addpelaporlain($params1,$data_pelaporlain);
        }
        
        $terlapor_nama=$request->terlapor_nama;
        $terlapor_alamat=$request->terlapor_alamat;
        $terlapor_provinsi=$request->terlapor_provinsi;
        $terlapor_kabkota=$request->terlapor_kabkota;
        $terlapor_pekerjaan=$request->terlapor_pekerjaan;
        $terlapor_hp=$request->terlapor_hp;
        
        $index = 0;
        $urut=1;
        $data_terlapor = array();
        if(isset($terlapor_nama)){
            if($params['id_jenislaporan']==3){
                foreach($terlapor_nama as $item){
                    if($item!=''){
                        array_push($data_terlapor, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($terlapor_alamat[$index]),
                        'provinsi'=>getinpb($terlapor_provinsi[$index]),
                        'kabkota'=>getinpb($terlapor_kabkota[$index]),
                        'pekerjaan'=>getinpb($terlapor_pekerjaan[$index]),
                        'hp'=>getinpb($terlapor_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
            }
            else{
                foreach($terlapor_nama as $item){
                    if($item!=''){
                        array_push($data_terlapor, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($terlapor_alamat[$index]),
                        'provinsi'=>getinpb($terlapor_provinsi[$index]),
                        'kabkota'=>getinpb($terlapor_kabkota[$index]),
                        'pekerjaan'=>null,
                        'hp'=>getinpb($terlapor_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
            }
            $params1['id_laporan'] = $id;
            $data1=M_laporan::addterlapor($params1,$data_terlapor);
        }
        
        $saksi_nama=$request->saksi_nama;
        $saksi_alamat=$request->saksi_alamat;
        $saksi_provinsi=$request->saksi_provinsi;
        $saksi_kabkota=$request->saksi_kabkota;
        $saksi_hp=$request->saksi_hp;
        
        if($params['id_jenislaporan']!=3){
            $index = 0;
            $urut=1;
            $data_saksi = array();
            if(isset($saksi_nama)){
                foreach($saksi_nama as $item){
                    if($item!=''){
                        array_push($data_saksi, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($saksi_alamat[$index]),
                        'provinsi'=>getinpb($saksi_provinsi[$index]),
                        'kabkota'=>getinpb($saksi_kabkota[$index]),
                        'hp'=>getinpb($saksi_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
                $params2['id_laporan'] = $id;
                $data2=M_laporan::addsaksi($params2,$data_saksi);
            }
        }
        
		$no=M_laporan::select('no')->where('id','=',$id)->first()->no;
        $index = 0;
        $urut=1;
        $date=new DateTime();
        $bukti_nama=$request->bukti_nama;
        $bukti_idx=$request->bukti_idx;
        $data_bukti = array();
        if(isset($bukti_nama)){
            foreach($bukti_nama as $item){
                if($item!=''){
                    array_push($data_bukti, array(
                    'urut'=>$urut,
                    'id_laporan'=>getinpb($id),
                    'deskripsi'=>getinpb($item),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params3['id_laporan'] = $id;
            $data3=M_laporan::addbukti($params3,$data_bukti);
        }
        $index = 0;
        $urut=1;
        $petitum_nama=$request->petitum_nama;
        $data_petitum = array();
        if(isset($petitum_nama)){
            foreach($petitum_nama as $item){
                if($item!=''){
                    array_push($data_petitum, array(
                    'urut'=>$urut,
                    'id_laporan'=>$id,
                    'deskripsi'=>$item,
                    ));
                    $urut++;
                }
                $index++;
            }
            $params2['id_laporan'] = $id;
            $data2=M_laporan::addpetitum($params2,$data_petitum);
        }
        
        $jdl='';
        if($params['id_jenislaporan']==1){
            $jdl='Pemilihan';
        }
        elseif($params['id_jenislaporan']==2){
            $jdl='Pemilu';
        }
        elseif($params['id_jenislaporan']==3){
            $jdl='Administrasi Pemilu';
        }
        
        if($dt['operation']=="Tambah"){
            $stskonf=1;
            
            if($locus=='0'){
                $locusnm='Bawaslu RI';
            }
            else{
                if(substr($locus,3,2)=='00'){
                    $locusnm='Bawaslu Provinsi '.DB::table("m_provinsi")->where('kode','=',$locus)->first()->nama;
                }
                else{
                    if (session('be_uposisi')<2) {
                        $locusnm='Bawaslu Kabupaten/Kota '.DB::table("m_kabkota")->where('kode','=',$locus)->first()->nama;
                    } else {
                        if($params['jenistempatkejadian']=="Dalam Negeri")
                            $locusnm='Bawaslu Kabupaten/Kota '.DB::table("m_kabkota")->where('kode','=',$locus)->first()->nama;
                        else
                            $locusnm='Bawaslu '.getinp($request->kejadiannegara);
                    }
                }
            }
            
            if($params['id_pelapor']!=""){
				$no=M_laporan::select('no')->where('id','=',$id)->first()->no;
                $datapelapor=DB::table("t_user")->selectRaw('hp,email')->where('id_user','=',$params['id_pelapor'])->first();
                if($datapelapor){
                    $hp=$datapelapor->hp;
                    $email=$datapelapor->email;
                }
                if($hp!=""){
                    $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                    //$WhatsappService=new WhatsappService;
                    //$WhatsappService->sendMessageToWhatsapp($hp, 'Pelaporan sudah dibuat dengan no '.$no.'. Silahkan menyerahkan bukti dan dokumen terkait ke '.$locusnm.'.');
                }
                if($email!=''){
                    $paramsemail['toemail']=$email;
                    $paramsemail['subyek']='Pelaporan dengan no '.$no.' berhasil dibuat';
                    $paramsemail['pesan']='Pelaporan sudah dibuat dengan no '.$no.'.<br>Silahkan menyerahkan bukti dan dokumen terkait ke '.$locusnm.' dalam 1x24 jam<br><br>Terimakasih';
                    kirim_email($paramsemail);
                }
                $paramsnotif['pesan']='Pelaporan sudah dibuat dengan no '.$no.'. Silahkan menyerahkan bukti dan dokumen terkait ke '.$locusnm;
                $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                $paramsnotif['id_user']=$params['id_pelapor'];
                M_notifikasi::add($paramsnotif);
                
                $petugas_hp='';$petugas_id='';$petugas_stswa=0;
				$datapetugas=DB::table("m_user")->selectRaw('id_user,hp,stswa')->where('wilayah','=',$locus)->get();
                if($datapetugas){
                    foreach($datapetugas as $item){
                        $petugas_hp=$item->hp;
                        $petugas_id=$item->id_user;
                        $petugas_stswa=$item->stswa;
                    
                        if($petugas_hp!=""&&$petugas_stswa==1){
                            $hp=$petugas_hp;
                            $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                            //$WhatsappService=new WhatsappService;
                            //$WhatsappService->sendMessageToWhatsapp($hp, 'Pelaporan sudah dibuat dengan no '.$no);
                        }
                        if($petugas_id!=""){
                            $paramsnotif['pesan']='Pelaporan sudah dibuat dengan no '.$no;
                            $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                            $paramsnotif['id_user']=$petugas_id;
                            M_notifikasia::add($paramsnotif);
                        }
                    }
                }
            }
            $paramsnotif['pesan']='Pelaporan sudah dibuat dengan no '.$no;
            $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
            $paramsnotif['id_user']=session('be_uid');
            M_notifikasia::add($paramsnotif);
        }
        else{
            $stskonf=2;
        }
		return redirect()->route('m_laporan.konfirmasi',['stskonf'=>ec($stskonf),'id'=>ec($id)]);
    }
    function savea(Request $request){
        $id = getinp($request->id);
        $no = getinp($request->no);
		$id_jenislaporan=getinp($request->id_jenislaporan);
        $params['id'] =$id;
        $params['uraian'] = getinp($request->uraian);
        $params['no_offline'] = getinp($request->no_offline);
        $params['id_jenislaporan'] = getinp($request->id_jenislaporan);
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        $data=M_laporan_model::add($params);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => "Ubah",
               'note' => 'ID:'.$params['id'].', Title: No Laporan: '.$no,
               'ip' => $request->ip()
           )
        );
        $pelaporlain_nama=$request->pelaporlain_nama;
        $pelaporlain_alamat=$request->pelaporlain_alamat;
        $pelaporlain_provinsi=$request->pelaporlain_provinsi;
        $pelaporlain_kabkota=$request->pelaporlain_kabkota;
        $pelaporlain_hp=$request->pelaporlain_hp;
        
        $index = 0;
        $urut=1;
        $data_pelaporlain = array();
        if(isset($pelaporlain_nama)){
            foreach($pelaporlain_nama as $item){
                if($item!=''){
                    array_push($data_pelaporlain, array(
                    'urut'=>$urut,
                    'id_laporan'=>getinpb($id),
                    'nama'=>getinpb($item),
                    'alamat'=>getinpb($pelaporlain_alamat[$index]),
                    'provinsi'=>getinpb($pelaporlain_provinsi[$index]),
                    'kabkota'=>getinpb($pelaporlain_kabkota[$index]),
                    'hp'=>getinpb($pelaporlain_hp[$index]),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params1['id_laporan'] = $id;
            $data1=M_laporan::addpelaporlain($params1,$data_pelaporlain);
        }
        
        $terlapor_nama=$request->terlapor_nama;
        $terlapor_alamat=$request->terlapor_alamat;
        $terlapor_provinsi=$request->terlapor_provinsi;
        $terlapor_kabkota=$request->terlapor_kabkota;
        $terlapor_pekerjaan=$request->terlapor_pekerjaan;
        $terlapor_hp=$request->terlapor_hp;
        
        $index = 0;
        $urut=1;
        $data_terlapor = array();
        if(isset($terlapor_nama)){
            if($params['id_jenislaporan']==3){
                foreach($terlapor_nama as $item){
                    if($item!=''){
                        array_push($data_terlapor, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($terlapor_alamat[$index]),
                        'provinsi'=>getinpb($terlapor_provinsi[$index]),
                        'kabkota'=>getinpb($terlapor_kabkota[$index]),
                        'pekerjaan'=>getinpb($terlapor_pekerjaan[$index]),
                        'hp'=>getinpb($terlapor_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
            }
            else{
                foreach($terlapor_nama as $item){
                    if($item!=''){
                        array_push($data_terlapor, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($terlapor_alamat[$index]),
                        'provinsi'=>getinpb($terlapor_provinsi[$index]),
                        'kabkota'=>getinpb($terlapor_kabkota[$index]),
                        'pekerjaan'=>null,
                        'hp'=>getinpb($terlapor_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
            }
            $params1['id_laporan'] = $id;
            $data1=M_laporan::addterlapor($params1,$data_terlapor);
        }
        
        $saksi_nama=$request->saksi_nama;
        $saksi_alamat=$request->saksi_alamat;
        $saksi_provinsi=$request->saksi_provinsi;
        $saksi_kabkota=$request->saksi_kabkota;
        $saksi_hp=$request->saksi_hp;
        
        if($params['id_jenislaporan']!=3){
            $index = 0;
            $urut=1;
            $data_saksi = array();
            if(isset($saksi_nama)){
                foreach($saksi_nama as $item){
                    if($item!=''){
                        array_push($data_saksi, array(
                        'urut'=>$urut,
                        'id_laporan'=>getinpb($id),
                        'nama'=>getinpb($item),
                        'alamat'=>getinpb($saksi_alamat[$index]),
                        'provinsi'=>getinpb($saksi_provinsi[$index]),
                        'kabkota'=>getinpb($saksi_kabkota[$index]),
                        'hp'=>getinpb($saksi_hp[$index]),
                        ));
                        $urut++;
                    }
                    $index++;
                }
                $params2['id_laporan'] = $id;
                $data2=M_laporan::addsaksi($params2,$data_saksi);
            }
        }
        
		$no=M_laporan::select('no')->where('id','=',$id)->first()->no;
        $index = 0;
        $urut=1;
        $date=new DateTime();
        $bukti_nama=$request->bukti_nama;
        $bukti_idx=$request->bukti_idx;
        $data_bukti = array();
        if(isset($bukti_nama)){
            foreach($bukti_nama as $item){
                if($item!=''){
                    array_push($data_bukti, array(
                    'urut'=>$urut,
                    'id_laporan'=>getinpb($id),
                    'deskripsi'=>getinpb($item),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params3['id_laporan'] = $id;
            $data3=M_laporan::addbukti($params3,$data_bukti);
        }
        //exit;
        //redirect('m_laporan');
        $index = 0;
        $urut=1;
        $petitum_nama=$request->petitum_nama;
        $data_petitum = array();
        if(isset($petitum_nama)){
            foreach($petitum_nama as $item){
                if($item!=''){
                    array_push($data_petitum, array(
                    'urut'=>$urut,
                    'id_laporan'=>getinpb($id),
                    'deskripsi'=>getinpb($item),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params2['id_laporan'] = $id;
            $data2=M_laporan::addpetitum($params2,$data_petitum);
        }
        $stskonf=2;
		return redirect()->route('m_laporan.konfirmasi',[ec($stskonf),ec($id)]);
    }
    function index_fm($id_jenislaporan=null){
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $jdl='';
        if($id_jenislaporan==1){
            $jdl='Pemilihan';
        }
        elseif($id_jenislaporan==2){
            $jdl='Pemilu';
        }
        $title= 'File Arsip '.$jdl;
        $main= 'be.m_fm_list';
        $arrLink=array(
                array("Pelaporan",route('m_laporan.index_fm').'/'.$ec_id_jenislaporan)
                );
        $params['id_periode']=DB::table('m_periode')->where('aktif','=',1)->first()->id;
        $params['locus'] =session('be_uwilayah');
        $params['id_jenislaporan'] = $id_jenislaporan;
        $list = M_laporan::daftar_fm($params);
		return view($main,compact('title','arrLink','list'));
    }
    function view_fm($id=null){
        if(!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $id=dc($id);
        $title = 'File Arsip';
        $main = 'be.m_fm_view';
        $params['id']= $id;
		$data=null;
        if($id!=""){
            $data=M_laporan::daftara($params);
            if(!empty($data)){
                $ceklocus=$data->locus;
                if(!General::cekaksesview($ceklocus)){
                    return redirect()->route('denied');
                }
                $id_jenislaporan=$data->id_jenislaporan;
            }
            else{
                return redirect()->route('denied');
            }
        }
		return view($main,compact('title','data'));
    }
    function konfirmasi($stskonf=null,$id=null){
        if(!cekint(dc($stskonf))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_stskonf=$stskonf;
        $ec_id=$id;
        $stskonf=dc($stskonf);
        $id=dc($id);
        
        $title = 'Konfirmasi';
        $data['main'] = 'm_laporan_konf';
        $stskonf = $stskonf;
        if(isset($id)){
			$data=DB::table('t_laporan')->where('id','=',$id)->first();
            if($data){
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
		return view('be.m_laporan_konf',compact('title','stskonf','data'));
    }
    function mview($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        $title = 'View Pelaporan';
        $params['id']= $id;
        if($id!=""){
            $data = M_laporan::daftara($params);
            if(!empty($data)){
                $ceklocus=$data->locus;
                if(!General::cekaksesview($ceklocus)){
                    return redirect()->route('denied');
                }
                $id_jenislaporan=$data->id_jenislaporan;
				
           		$m_petitum=null;
				$m_pelaporlain=DB::table('t_pelaporlain')->where('id_laporan','=',$id)->get();
				$m_terlapor=DB::table('t_terlapor')->where('id_laporan','=',$id)->get();
				$m_saksi=DB::table('t_saksi')->where('id_laporan','=',$id)->get();
				$m_bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->get();
				if($id_jenislaporan==3){
					$m_petitum=DB::table('t_petitum')->where('id_laporan','=',$id)->get();
				}
            }
            else{
                return redirect()->route('denied');
            }
        }
        $id_jenislaporan=$id_jenislaporan;
		return view('be.m_laporan_view',compact('title','id_jenislaporan','data','m_pelaporlain','m_terlapor','m_saksi','m_bukti','m_petitum'));
    }
    function mtahapan($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
	    $title = 'Tahapan Pelaporan';
        $params['id']= $id;
        if($id!=""){
            $data = M_laporan::daftara($params);
            if(!empty($data)){
                $ceklocus=$data->locus;
                $cekstsposisi=$data->stsposisi;
                if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
			
            $m_petitum=null;
            $m_tahapan = DB::table('m_tahapan')->get();
            $m_pelaporlain=DB::table('t_pelaporlain')->where('id_laporan','=',$id)->get();
			$m_terlapor=DB::table('t_terlapor')->where('id_laporan','=',$id)->get();
			$m_saksi=DB::table('t_saksi')->where('id_laporan','=',$id)->get();
			$m_bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->get();
			if($id_jenislaporan==3){
				$m_petitum=DB::table('t_petitum')->where('id_laporan','=',$id)->get();
			}
        }
        $id_jenislaporan=$id_jenislaporan;
		return view('be.m_laporan_tahapan',compact('title','id_jenislaporan','data','m_pelaporlain','m_terlapor','m_saksi','m_bukti','m_petitum','m_tahapan'));
    }
    function save_tahapan(Request $request){
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $id= getinp($request->id);
        if(!cekjenislapor3($id_jenislaporan)||!cekint($id)){
            return redirect()->route('denied');
        }
        if($id!=""){
			$datalap=DB::table('t_laporan')->selectRaw('locus,stsposisi')->where('id','=',$id)->limit(1)->first();
            if(!empty($datalap)){
                $ceklocus=$datalap->locus;
                $stsposisi=$datalap->stsposisi;
                if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        $params['id']=$id;
        $params['id_tahapan']= getinp($request->tahapan);
		M_laporan::add($params);
        $no= $request->no;
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => 'Ubah Tahapan Pelaporan',
               'note' => 'ID:'.$params['id'].', Title: No Laporan: '.$no,
               'ip' => $request->ip()
           )
        );
		return redirect()->route('m_laporan.index',['id_jenislaporan'=>ec($id_jenislaporan)])->with('success',' Ubah Data Tahapan Pelaporan Berhasil');
    }
    function mvalidasi($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
		$title = 'Validasi Pelaporan';
        $params['id']= $id;
        if($id!=""){
            $data = M_laporan::daftara($params);
            if(!empty($data)){
                $ceklocus=$data->locus;
                $cekstsposisi=$data->stsposisi;
                if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            if($id_jenislaporan==1){
				$m_tahapan = DB::table('m_tahapan')->where('id_jenislaporan','=',1)->get();
            }
            if($id_jenislaporan==2){
				$m_tahapan = DB::table('m_tahapan')->where('id_jenislaporan','=',2)->get();
            }
			$m_petitum=null;
            $m_pelaporlain=DB::table('t_pelaporlain')->where('id_laporan','=',$id)->get();
			$m_terlapor=DB::table('t_terlapor')->where('id_laporan','=',$id)->get();
			$m_saksi=DB::table('t_saksi')->where('id_laporan','=',$id)->get();
			$m_bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->get();
			if($id_jenislaporan==3){
				$m_petitum=DB::table('t_petitum')->where('id_laporan','=',$id)->get();
			}
        }
        $id_jenislaporan=$id_jenislaporan;
		return view('be.m_laporan_validasi',compact('title','id_jenislaporan','data','m_pelaporlain','m_terlapor','m_saksi','m_bukti','m_petitum','m_tahapan'));
    }
    function save_validasi(Request $request){
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $id= getinp($request->id);
        if(!cekjenislapor3($id_jenislaporan)||!cekint($id)){
            return redirect()->route('denied');
        }
        if($id!=""){
			$datalap=DB::table('t_laporan')->selectRaw('locus,stsposisi')->where('id','=',$id)->limit(1)->first();
            if(!empty($datalap)){
                $ceklocus=$datalap->locus;
                $stsposisi=$datalap->stsposisi;
                if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        $params['id']=$id;
        $params['id_tahapan']= getinp($request->tahapan);
        $params['stsvalid']= getinp($request->stsvalid);
        $params['stsvalid_by'] =  session('be_uid');
        $params['stsvalid_date'] =  getinp($request->stsvalid_date);
        $no= $request->no;
        if($id_jenislaporan==3){
            $params['no_registrasi']=Nomor::getnourutreg($no);
            $params['stslap']=1;
            $params['stslap_by'] =  sessiob('be_uid');
            $params['stslap_date'] =  date("Y-m-d H:i:s");
            $params['stsposisi']='Pelaporan diregister';
        }
        else{
            $params['stsposisi']='Validasi Pelaporan';
        }
        M_laporan::add($params);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => 'Validasi Pelaporan',
               'note' => 'ID:'.$params['id'].', Title: No Laporan: '.$no,
               'ip' => $request->ip()
           )
        );
        return redirect()->route('m_laporan.index',['id_jenislaporan'=>ec($id_jenislaporan)])->with('success',' Validasi Pelaporan Berhasil');
    }
    function save_notif(Request $request){
        $no= getinp($request->no);
        $id_pelapor = getinp($request->id_pelapor);
        $notif = $request->notif;
        $paramsnotif['pesan']='Pesan untuk dokumen pelaporan '.$no.': '.$notif;
        $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
        $paramsnotif['id_user']=$id_pelapor;
        $data=M_notifikasi::add($paramsnotif);
        
        if(!cekint($id_pelapor)){
            return redirect()->route('denied');
        }
        if($id_pelapor!=""){
			$data=DB::table('t_user')->selectRaw('hp,email,nama')->where('id_user','=',$id_pelapor)->first();
            $hp=$data->hp;
            $email=$data->email;
            $nama=$data->nama;
            if($hp!=""){
                $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                //$WhatsappService=new WhatsappService;
                //$WhatsappService->sendMessageToWhatsapp($hp, $paramsnotif['pesan']);
            }
            if($email!=""){
                $paramsemail['toemail']=$email;
                $paramsemail['subyek']='Notifikasi dari SIGAPLapor Bawaslu';
                $paramsemail['pesan']=$paramsnotif['pesan'];
                kirim_email($paramsemail);
            }
        }
        echo $data;
    }
    function cetak_prn($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
		$title="Cetak Laporan";
        if(isset($id)){
            $laporan = M_laporan::daftara(array('id' =>$id));
            if($laporan){
                if(!General::cekaksesview($laporan->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
			$m_petitum=null;
            $pelapor = User::daftar(array('id' => $laporan->id_pelapor));
            $m_pelaporlain=M_laporan::daftar_pelaporlain(array('id_laporan' => $id));
            $m_terlapor=M_laporan::daftar_terlapor(array('id_laporan' => $id));
            $m_saksi=M_laporan::daftar_saksi(array('id_laporan' => $id));
            $m_bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->orderBy('urut','asc')->get();
			if($id_jenislaporan==3){
				$m_petitum=DB::table('t_petitum')->where('id_laporan','=',$id)->orderBy('urut','asc')->get();
			}
            
			$html = view('be.m_laporan_prn',compact('title','id_jenislaporan','laporan','pelapor','m_pelaporlain','m_terlapor','m_saksi','m_bukti','m_petitum'));
            echo $html;
            die();
        }
        else{
            return redirect()->route('denied');
        }
    }
    function cetak_mod31($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
		$title="Cetak Laporan m_laporan_mod31";
        if(isset($id)){
            $laporan = M_laporan::daftara(array('id' =>$id));
            if($laporan){
                if(!General::cekaksesview($laporan->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
			
			$m_petitum=null;
            $pelapor = User::daftar(array('id' => $laporan->id_pelapor));
            $bukti=DB::table('t_kajianawal_dokumen_perbaikan as a')->join('t_kajianawal as b','a.id_kajianawal','=','b.id')
					 ->where('b.id_laporan',$id)
					 ->selectRaw('a.note deskripsi,a.edit_date, a.create_date, a.id, a.tgl')
            		 ->orderBy("a.id", "desc")->get();
					 
			$html = view('be.m_laporan_mod31',compact('title','id_jenislaporan','laporan','pelapor','bukti'));
            echo $html;
            die();
        }
        else{
            return redirect()->route('denied');
        }
    }
    function cetak_mod3($id_jenislaporan=null,$id=null){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        $title="Cetak Laporan m_laporan_mod3";
        //$data['main'] = 'm_laporan_mod3';
        if(isset($id)){
            $laporan = M_laporan::daftara(array('id' =>$id));
            if($laporan){
                if(!General::cekaksesview($laporan->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            $pelapor = User::daftar(array('id' => $laporan->id_pelapor));
            $bukti=DB::table('t_bukti')->where('id_laporan','=',$id)->orderBy('urut','asc')->get();
            
			$html = view('be.m_laporan_mod3',compact('title','id_jenislaporan','laporan','pelapor','bukti'));
            echo $html;
            die();
        }
        else{
            return redirect()->route('denied');
        }
    }
    function del($id_jenislaporan=null,$id=null,Request $request){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        if($id!=""){
			$datalap=DB::table('t_laporan')->selectRaw('no,locus,stsposisi')->where('id','=',$id)->limit(1)->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $stsposisi=$datalap->stsposisi;
                if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
        
        M_laporan::del($id);
		return redirect()->route('m_laporan.index',['id_jenislaporan'=>ec($id_jenislaporan)])->with('success',' Hapus Pelaporan Berhasil');
    }
    function delalltrans($id_jenislaporan=null,$id=null,$from=null,Request $request){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        if($id!=""){
			$datalap=DB::table('t_laporan')->selectRaw('no,locus,stsposisi')->where('id','=',$id)->limit(1)->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $stsposisi=$datalap->stsposisi;
				if(General::cekaksesedit($ceklocus)){
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Laporan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Semua Pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
        $str="call del_laporanall(".$id.")";
        DB::select($str);
        if($from==0){
			return redirect()->route('m_laporan.index',['id_jenislaporan'=>ec($id_jenislaporan)])->with('success',' Hapus Pelaporan Berhasil');
        }
        else{
			return redirect()->route('m_laporan.unreg',['id_jenislaporan'=>ec($id_jenislaporan)])->with('success',' Hapus Pelaporan Berhasil');
        }
    }
	function test(){
		echo is_file(public_path()."/media/uploads/kajianawal/001_TM_PB_Kab_03,18_VIII_2024-2024-12-06-20-00-39-dokumen_registrasi");
	}
}
