<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_laporan;
use App\Models\General;
use App\Models\M_klarifikasi;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_KlarifikasiController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Klarifikasi';
		$tambah = 'href="'.route('m_klarifikasi.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_klarifikasi_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_klarifikasi::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('no_ringkasan', function ($arrData){
				return $arrData->no.'<br><br>'.substr($arrData->ringkasan,0,50).'...';
			})
			->addColumn('tanggal_jadwal', function ($arrData){
				return konversi_tanggal('d-M-Y H:i:s',$arrData->tanggal,'idshort');
			})
			->addColumn('proses_short', function ($arrData){
				return substr($arrData->proses,0,50).'...';
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_klarifikasi.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_klarifikasi.daftar_proses').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-settings"></i> Proses</a></li>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_klarifikasi.daftar_berkas').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Berkas</a></li>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_klarifikasi.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function daftar_proses($id_jenislaporan=null,$id_klarifikasi=null){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$datalap=null;
		$tambah=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Proses Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiproses_list';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		}
		$params['id_klarifikasi'] = $id_klarifikasi;
		$list = M_klarifikasi::daftar_proses($params);
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','tambah','datalap','no','locus','stsposisi','list'));
	}
	function daftar_berkas($id_jenislaporan=null,$id_klarifikasi=null){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$datalap=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$title = 'Berkas Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiberkas_list';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Berkas",route('m_klarifikasi.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		$tambah=null;
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		}
		$params['id_klarifikasi'] = $id_klarifikasi;
		$list = M_klarifikasi::daftar_berkas($params);
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','tambah','datalap','no','locus','stsposisi','list'));
	}
	function daftar_dokumen($id_jenislaporan=null,$id_klarifikasi=null,$id_klarifikasiproses=null){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id_klarifikasiproses))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id_klarifikasiproses=$id_klarifikasiproses;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id_klarifikasiproses=dc($id_klarifikasiproses);
		$datalap=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
		}
		$paramsgetproses['id']=$id_klarifikasiproses;
		$proses=M_klarifikasi::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Klarifikasi <br><font class=subjudul>'.$no.'<br>Step : '.$proses->stepnm.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'be.m_klarifikasidok_list';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi),
				array("Dokumen",route('m_klarifikasi.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses)
				);
		$tambah=null;
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses.'"';
		}
		$params['id_klarifikasiproses'] = $id_klarifikasiproses;
		$params['id_klarifikasi'] = $id_klarifikasi;
		$list = M_klarifikasi::daftar_dokumen($params);
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','id_klarifikasiproses','tambah','datalap','no','locus','stsposisi','list','proses'));
	}
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_klarifikasi::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				$id_jenislaporan==$data->id_jenislaporan;
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
		}
		$title = 'Tambah Klarifikasi';
     	$main = 'be.m_klarifikasi_add';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_klarifikasi.add').'/'.$ec_id_jenislaporan.'"';
		$params['id_jenislaporan'] = $id_jenislaporan;
     	$params['table'] = 't_klarifikasi';
		$params['stsposisi'] = 'Undangan';
		$params['locus'] =session('be_uwilayah');
		$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		$listlaporan = M_laporan::daftardengannoreg($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_klarifikasi::daftar($paramsdt);
			if($data){
				$id_jenislaporan==$data->id_jenislaporan;
				if(!General::cekaksesview($data->locus)){
					return redirect()->route('denied');
				}
			}
		}
		else{
			return redirect()->route('denied');
		}
		$title = 'Klarifikasi';
     	$main = 'be.m_klarifikasi_view';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_klarifikasi.add').'/'.$ec_id_jenislaporan.'"';
		$params['id_jenislaporan'] = $id_jenislaporan;
     	$params['table'] = 't_klarifikasi';
	 	$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		$listlaporan = M_laporan::daftardengannoreg($params);
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function add_proses($id_jenislaporan=null,$id_klarifikasi = NULL, $id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		$datalap=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Proses Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiproses_add';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		$tambah = 'href="'.route('m_klarifikasi.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		$m_klarifikasi_step=DB::table('m_klarifikasi_step')->get();
		$data=null;
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_proses($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','tambah','datalap','no','locus','stsposisi','m_klarifikasi_step','data'));
	}
	function view_proses($id_jenislaporan=null,$id_klarifikasi = NULL, $id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Proses Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiproses_view';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		$tambah =null;
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		}
		$m_klarifikasi_step = DB::table('m_klarifikasi_step')->get();
		$data=null;
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_proses($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','tambah','datalap','no','locus','stsposisi','m_klarifikasi_step','data'));
	}
	function add_berkas($id_jenislaporan=null,$id_klarifikasi = NULL, $id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		$datalap=null;
		$data=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Berkas Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiberkas_add';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("berkas",route('m_klarifikasi.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		$tambah = 'href="'.route('m_klarifikasi.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_berkas($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','id_klarifikasi','tambah','datalap','no','locus','data'));
	}
	function view_berkas($id_jenislaporan=null,$id_klarifikasi = NULL, $id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		$datalap=null;
		$data=null;
		$tambah=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$title = 'Berkas Klarifikasi <br><font class=subjudul>'.$no.'</font>';
     	$main = 'be.m_klarifikasiberkas_view';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("berkas",route('m_klarifikasi.daftar_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_berkas').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'"';
		}
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_berkas($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_klarifikasi','datalap','no','locus','stsposisi','data'));
	}
	function add_dokumen($id_jenislaporan=null,$id_klarifikasi = NULL,$id_klarifikasiproses=null,$id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id_klarifikasiproses))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id_klarifikasiproses=$id_klarifikasiproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id_klarifikasiproses=dc($id_klarifikasiproses);
		$id=dc($id);
		$datalap=null;
		$data=null;
		$tambah=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(General::cekaksesedit($locus)){
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$paramsgetproses['id']=$id_klarifikasiproses;
		$proses =M_klarifikasi::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Klarifikasi <br><font class=subjudul>'.$no.'<br>Step : '.$proses->proses.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'm_klarifikasidok_add';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi),
				array("Dokumen",route('m_klarifikasi.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses)
				);
		$tambah = 'href="'.route('m_klarifikasi.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses.'"';
		
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_dokumen($params);
		}
		return view('be.m_klarifikasidok_add',compact('arrLink','title','id_jenislaporan','tambah','id_klarifikasi','id_klarifikasiproses','datalap','no','locus','proses','data'));
	}
	function view_dokumen($id_jenislaporan=null,$id_klarifikasi = NULL,$id_klarifikasiproses=null,$id=NULL){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id_klarifikasiproses))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id_klarifikasiproses=$id_klarifikasiproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id_klarifikasiproses=dc($id_klarifikasiproses);
		$id=dc($id);
		$datalap=null;
		$data=null;
		$tambah=null;
		
		$paramsgetlap['id']=$id_klarifikasi;
		$no='';$locus='';$stsposisi='';
		if($paramsgetlap['id']!=""){
			$datalap=M_klarifikasi::getlaporan($paramsgetlap);
			$no=$datalap->no;
			$locus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$id_jenislaporan=$datalap->id_jenislaporan;
			
			if(!General::cekaksesview($locus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$paramsgetproses['id']=$id_klarifikasiproses;
		$proses =M_klarifikasi::daftar_proses($paramsgetproses);
		
		$title = 'Dokumen Klarifikasi <br><font class=subjudul>'.$no.'<br>Step : '.$proses->proses.', Tanggal : .'.konversi_tanggal('d-M-Y H:i:s',$proses->tanggal,'idshort').'</font>';
     	$main = 'be.m_klarifikasidok_view';
     	$arrLink=array(
				array("Klarifikasi",route('m_klarifikasi.index').'/'.$ec_id_jenislaporan),
				array("Proses",route('m_klarifikasi.daftar_proses').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi),
				array("Dokumen",route('m_klarifikasi.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses)
				);
		if($locus==session('be_uwilayah')||session('be_urole')==3){
			$tambah = 'href="'.route('m_klarifikasi.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_klarifikasi.'/'.$ec_id_klarifikasiproses.'"';
		}
		if(isset($id)){
			$params['id']=$id;
			$data = M_klarifikasi::daftar_dokumen($params);
		}
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','id_klarifikasi','id_klarifikasiproses','datalap','no','locus','stsposisi','proses','data'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['kuasa_hukum'] = getinp($request->kuasa_hukum);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		
		if($dt['operation']=='Ubah'){
			$datalap=DB::table('t_klarifikasi as a')->join('t_laporan as b','a.id_laporan','=','b.id')
					->selectRaw('b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$ceklocus=$datalap->locus;
				$cekstsposisi=$datalap->stsposisi;
				
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			$datalap=M_laporan::selectRaw('no,locus,stsposisi')->where('id',$params['id_laporan'])->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$ceklocus=$datalap->locus;
				$cekstsposisi=$datalap->stsposisi;
				
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Klarifikasi';
		M_laporan::setposisi($paramslaporan);
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_klarifikasi::add($params);
		if($data){
			$id=$data;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_klarifikasi.index').'/'.ec($id_jenislaporan);
	}
	function save_proses(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_klarifikasi'] = getinp($request->id_klarifikasi);
		
		if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_klarifikasi'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		$datalap=DB::table('t_klarifikasi as a')->join('t_laporan as b','a.id_laporan','=','b.id')
					->selectRaw('b.no,b.locus,b.stsposisi')->where('a.id',$params['id_klarifikasi'])->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(!General::cekaksesedit($ceklocus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$params['id_step'] = getinp($request->id_step);
		$params['harike'] = getinp($request->harike);
		$params['tanggal'] = getinp($request->tanggal);
		$params['proses'] = getinp($request->proses);
		$params['keterangan'] = getinp($request->keterangan);
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		$data=M_klarifikasi::add_proses($params);
		$paramsupd['proses']='';
		if($data){
			$id=$data;
		}
		if(isset($id)){
			$paramsupdparent['id'] = $params['id_klarifikasi'];
			$paramsupdparent['tanggal']=$params['tanggal'];
			$paramsupdparent['proses']=$params['proses'];
			$paramsupdparent['keterangan']=$params['keterangan'];
			$paramsupdparent['edit_by'] =  session('be_uid');
			$paramsupdparent['edit_date'] =  date("Y-m-d H:i:s");
			$data=M_klarifikasi::add($paramsupdparent);
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Proses',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan dengan proses '.$params['proses'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_klarifikasi.daftar_proses').'/'.ec($id_jenislaporan).'/'.ec($params['id_klarifikasi']);
	}
	function save_berkas(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_klarifikasi'] = getinp($request->id_klarifikasi);
		
		if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_klarifikasi'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$datalap=DB::table('t_klarifikasi as a')->join('t_laporan as b','a.id_laporan','=','b.id')
					->selectRaw('b.no,b.locus,b.stsposisi')->where('a.id',$params['id_klarifikasi'])->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(!General::cekaksesedit($ceklocus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$params['diserahkan'] = getinp($request->diserahkan);
		$params['banyak'] = getinp($request->banyak);
		$params['keterangan'] = getinp($request->keterangan);
		$params['pihak'] = getinp($request->pihak);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_klarifikasi::add_berkas($params);
		if($data){
			$id=$data;
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Berkas',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan dengan berkas diserahkan oleh '.$params['diserahkan'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_klarifikasi.daftar_berkas').'/'.ec($id_jenislaporan).'/'.ec($params['id_klarifikasi']);
	}
	function save_dokumen(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_klarifikasi'] = getinp($request->id_klarifikasi);
		
		if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_klarifikasi'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		$datalap=DB::table('t_klarifikasi as a')->join('t_laporan as b','a.id_laporan','=','b.id')
					->selectRaw('b.no,b.locus,b.stsposisi')->where('a.id',$params['id_klarifikasi'])->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(!General::cekaksesedit($ceklocus)){
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
		$params['id_klarifikasiproses'] = getinp($request->id_klarifikasiproses);
		$params['deskripsi'] = getinp($request->deskripsi);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['id']!=""){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		else{
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_klarifikasi::add_dokumen($params);
		$paramsupd['dokumen']='';
		if($data){
			$id=$data;
		}
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'klarifikasi',$no.'-'.$date->format('Y-m-d-H-i-s'),$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
			$data=M_klarifikasi::add_dokumen($paramsupd);
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Dokumen',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan dengan dokumen '.$params['deskripsi'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_klarifikasi.daftar_dokumen').'/'.ec($id_jenislaporan).'/'.ec($params['id_klarifikasi']).'/'.ec($params['id_klarifikasiproses']);
	}
	function del($id_jenislaporan=null,$id = NULL,Request $request){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table('t_klarifikasi as a')->join('t_laporan as b','a.id_laporan','=','b.id')
					->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
		$no='';
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_klarifikasi::del($id);
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		$params['stsposisi']='Undangan';
		M_laporan::add($params);
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		return redirect()->route('m_klarifikasi.index',[$ec_id_jenislaporan]);
	}
	function del_proses($id_jenislaporan=null,$id_klarifikasi=NULL, $id = NULL,Request $request){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		
		$no='';$proses='';
		$datalap=DB::table('t_klarifikasi_proses as a')
					->join('t_klarifikasi as b','a.id_klarifikasi','=','b.id')
					->join('t_laporan as c','b.id_laporan','=','c.id')
					->selectRaw('c.no,c.locus,c.stsposisi,a.proses')
					->where('a.id',$id)->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$proses=$datalap->proses;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Proses',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan proses '.$proses.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		
		$data=M_klarifikasi::del_proses($id);
		$doklast=DB::table('t_klarifikasi_proses')->where('id_klarifikasi',$id_klarifikasi)->orderBy('id', 'desc')->first();
		if($doklast){
			$paramsupdparent['tanggal']=IndonesiaTglTime($doklast->tanggal);
			$paramsupdparent['proses']=$doklast->proses;
			$paramsupdparent['keterangan']=$doklast->keterangan;
		}
		else{
			$paramsupdparent['tanggal']='';
			$paramsupdparent['proses']='';
			$paramsupdparent['keterangan']='';
		}
		$paramsupdparent['id']=$id_klarifikasi;
		$paramsupdparent['edit_by'] =  session('be_uid');
		$paramsupdparent['edit_date'] =  date("Y-m-d H:i:s");
		M_klarifikasi::add($paramsupdparent);
		return redirect()->route('m_klarifikasi.daftar_proses',[$ec_id_jenislaporan,$ec_id_klarifikasi]);
	}
	function del_berkas($id_jenislaporan=null,$id_klarifikasi=NULL, $id = NULL,Request $request){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id=dc($id);
		
		$no='';$diserahkan='';
		$datalap=DB::table('t_klarifikasi_berkas as a')
					->join('t_klarifikasi as b','a.id_klarifikasi','=','b.id')
					->join('t_laporan as c','b.id_laporan','=','c.id')
					->selectRaw('c.no,c.locus,c.stsposisi,a.diserahkan')
					->where('a.id',$id)->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$diserahkan=$datalap->diserahkan;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Berkas',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan berkas '.$diserahkan.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_klarifikasi::del_berkas($id);
		return redirect()->route('m_klarifikasi.daftar_berkas',[$ec_id_jenislaporan,$ec_id_klarifikasi]);
	}
	function del_dokumen($id_jenislaporan=null,$id_klarifikasi=NULL, $id_klarifikasiproses=NULL, $id = NULL,Request $request){
		if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_klarifikasi))||!cekint(dc($id_klarifikasiproses))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id_klarifikasi=$id_klarifikasi;
		$ec_id_klarifikasiproses=$id_klarifikasiproses;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id_klarifikasi=dc($id_klarifikasi);
		$id_klarifikasiproses=dc($id_klarifikasiproses);
		$id=dc($id);
		
		$no='';$deskripsi='';
		$datalap=DB::table('t_klarifikasi_prosesfile as a')
					->join('t_klarifikasi_proses as b','a.id_klarifikasiproses','=','b.id')
					->join('t_klarifikasi as c','b.id_klarifikasi','=','c.id')
					->join('t_laporan as d','c.id_laporan','=','d.id')
					->selectRaw('d.no,d.locus,d.stsposisi,a.deskripsi')
					->where('a.id',$id)->first();
		if(!empty($datalap)){
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			$deskripsi=$datalap->deskripsi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Klarifikasi::Dokumen',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Klarifikasi dengan pelaporan no '.$no.' dan dokumen '.$deskripsi.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_klarifikasi::del_dokumen($id);
		return redirect()->route('m_klarifikasi.daftar_dokumen',[$ec_id_jenislaporan,$ec_id_klarifikasi,$ec_id_klarifikasiproses]);
	}
}
