<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_notifikasi;
use App\Models\M_notifikasia;
use App\Models\Kasn;
use App\Models\Nomor;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_kajianawal;
use App\Models\M_kajianawal_kategori;
use App\Models\M_trendpelanggaran;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_KajianAwalController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Kajian Awal';
		$tambah = 'href="'.route('m_kajianawal.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_kajianawal_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_kajianawal::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('no_registrasis', function ($arrData){
				return ($arrData->no_registrasi ? $arrData->no_registrasi.'<br />'.$arrData->no_registrasi2 : $arrData->no_registrasi2);
			})
			->addColumn('notes', function ($arrData){
				$s=substr($arrData->note,0,50).'...';
				if($arrData->dokumen!=""){
					$s.='<br><a href="'.route("download.be_kw_dk").'/'.rawurlencode($arrData->dokumen).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('status', function ($arrData){
				return ($arrData->stsfinal==1?'Selesai Kajian':'Draft Kajian');
			})
			->addColumn('kajianawal', function ($arrData){
				$s='';
				if($arrData->id_kat1!=""||$arrData->id_kat2!=""||$arrData->id_kat3!=""){
					$s.='<table celpadding=0 cellspacing=0 class=borderless>';
                         if($arrData->kat1nm!=""){
                         $s.='<tr>
                             <td valign=top width=20% ><nobr>Kat 1</td>
                             <td valign=top width=1>:</td>
                             <td width=80% >'.$arrData->kat1nm.'</td>
                         </tr>';
                         }
                         if($arrData->kat2nm!=""){
                         $s.='<tr>
                             <td valign=top><nobr>Kat 2</td>
                             <td valign=top>:</td>
                             <td>'.$arrData->kat2nm.'</td>
                         </tr>';
                         }
                         if($arrData->kat3nm!=""){
                         $s.='<tr>
                             <td valign=top><nobr>Kat 3</td>
                             <td valign=top>:</td>
                             <td>'.$arrData->kat3nm.'</td>
                         </tr>';
                         }
                 	$s.='</table>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_kajianawal.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_kajianawal.daftar_dokumen').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Dokumen Kajian Awal</a>';
                          if (session('be_urole')==3){
                              $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_kajianawal.trend').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah Trend</a>';
                          }
						  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_kajianawal.daftar_dokumen_perbaikan').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Dokumen Perbaikan Laporan</a>
						  	   <li><a class="dropdown-item btn-sm" href="'.route('m_kajianawal.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
						       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
    function add_ajax_kat($id){
        $params['parent_id']=$id;
        if(session('be_uwilayah')=='0'){
			$query=DB::table('m_kajianawal_kategori')->where('parent_id','=',$id)->where('id','!=',8)->where('id','!=',12)->orderBy('urut','asc')->get();
        }
        else{
			$query=DB::table('m_kajianawal_kategori')->where('parent_id','=',$id)->orderBy('urut','asc')->get();
        }
        $data = "<option value=''>- Pilih Kategori -</option>";
        foreach ($query as $value) {
            $data .= "<option value='".$value->id."'>".$value->nama."</option>";
        }
        echo $data;
    }
	function get_trend($i=NULL,$id_jenislaporan=NULL){
        $data=DB::table("m_trendpelanggaran")->selectRaw('id,nama')->where('id_kat','=',$i)->where('id_jenislaporan','=',$id_jenislaporan)->get();
		echo json_encode($data);
    }
    function get_trendall(){
        $data=DB::table("m_trendpelanggaran")->selectRaw('id,nama')->where('id_jenislaporan','=',$id_jenislaporan)->get();
        echo json_encode($data);
    }
	function showerr($id_jenislaporan=null){
		$ec_id_jenislaporan=$id_jenislaporan;
		$arrLink=array(
			array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Kajian Awal';
		$isi='Pelaporan tidak bisa dilakukan karena tidak ada data petugas di wilayah pelimpahan';
		return view('be.m_kajianawal_err',compact('arrLink','title','id_jenislaporan','isi'));
    }
    function daftar_dokumen($id_jenislaporan=null,$id_kajianawal=null){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        
        $paramsgetlap['id']=$id_kajianawal;
        $datalap=M_kajianawal::getlaporan($paramsgetlap);
        $no=$datalap->no;
        $locus=$datalap->locus;
        $stsposisi=$datalap->stsposisi;
        $stsfinal=$datalap->stsfinal;
        $title = 'Dokumen Kajian Awal <br><font class=subjudul>'.$no.'</font>';
        $main = 'm_kajianawaldok_list';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Kajian Awal",route('m_kajianawal.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
        if(($locus==session('be_uwilayah'))||(session('be_urole')==3)){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $id_kajianawal=$id_kajianawal;
        $params['id_kajianawal'] = $id_kajianawal;
        $list = M_kajianawal::daftar_dokumen($params);
		return view('be.m_kajianawaldok_list',compact('arrLink','title','id_jenislaporan','tambah','id_kajianawal','no','locus','stsposisi','stsfinal','list'));
    }
    function daftar_dokumen_perbaikan($id_jenislaporan=null,$id_kajianawal=null){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        
        $paramsgetlap['id']=$id_kajianawal;
		$datalap=M_kajianawal::getlaporan($paramsgetlap);
        $no=$datalap->no;
        $locus=$datalap->locus;
        $stsposisi=$datalap->stsposisi;
        $stsfinal=$datalap->stsfinal;
		$tambah=null;
		
        $title = 'Dokumen Perbaikan Laporan <br><font class=subjudul>'.$no.'</font>';
        //$main = 'm_kajianawaldokperbaikan_list';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Perbaikan Laporan",route('m_kajianawal.daftar_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
        if(($locus==session('be_uwilayah')&&$stsfinal==0)||(session('be_urole')==3&&$stsfinal==0)){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $id_jenislaporan=$id_jenislaporan;
        $params['id_kajianawal'] = $id_kajianawal;
        $list =M_kajianawal::daftar_dokumen_perbaikan($params);
		return view('be.m_kajianawaldokperbaikan_list',compact('arrLink','title','id_jenislaporan','tambah','id_kajianawal','no','locus','stsposisi','stsfinal','list'));
    }
    function add($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        $get_g=null;
		
		$locus=null;
        $tgl_registrasi=null;
        $stsposisi=null;
        $stsfinal=null;
        $m_kat2=null;
        $m_kat3=null;
        $m_kabkota=null;
		$data=null;
		
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar($params);
            if($data){
                $locus=$data->locus;
                $tgl_registrasi=$data->tgl_registrasi;
                $stsposisi=$data->stsposisi;
                $stsfinal=$data->stsfinal;
                $id_jenislaporan=$data->id_jenislaporan;
                if(General::cekaksesedit($locus)&&$stsfinal==0){
                }
                else{
                    //return redirect()->route('denied');
                }
                if($data->id_kat1!=""){
                    $paramskat2['parent_id']=$data->id_kat1;
                    $paramskat2['order_by']='urut';
                    if(session('be_uwilayah')=='0'){
                        $paramskat2['not_id']='8,12';
                    }
                    $m_kat2 = M_kajianawal_kategori::daftar($paramskat2);
                }
                if($data->id_kat2!=""){
                    $paramskat3['parent_id']=$data->id_kat2;
                    $m_kat3 = M_kajianawal_kategori::daftar($paramskat3);
                }
                if($data->sel_pelimpahan==3||$data->sel_pelimpahan==4){
					$m_kabkota=DB::table("m_kabkota")->whereRaw("substring(kode,1,2)='".substr($data->locus_pelimpahan,0,2)."'")->get();
                }
            }
            else{
                return redirect()->route('denied');
            }
        } else {
            //$data->id_jenislaporan=$id_jenislaporan;
        }
        $title = 'Tambah Kajian Awal';
        $main = 'm_kajianawal_add';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianawal.add').'/'.$ec_id_jenislaporan.'"';
        
        $params['id_jenislaporan'] = $id_jenislaporan;
        $params['stsvalid'] = 1;
        $params['table'] = 't_kajianawal';
        $params['locus'] = session('be_uwilayah');
        $listlaporan = M_laporan::daftartanpanoreg($params);
        $kasn = Kasn::getaccesstoken();
        $paramskat1['level']=1;
		$provinsi = DB::table("m_provinsi")->get();
        $m_kat1 = M_kajianawal_kategori::daftar($paramskat1);
		$m_katawal = DB::table("m_kajianawala_kategori")->get();
        $m_trendpelanggaran = M_trendpelanggaran::daftar();
		return view('be.m_kajianawal_add',compact('arrLink','title','id_jenislaporan','tambah',
		'locus','stsposisi','stsfinal','tgl_registrasi','m_katawal','m_kat1','m_kat2','m_kat3','data',
		'm_kabkota','listlaporan','kasn','provinsi','m_trendpelanggaran','get_g'));
    }
	function kasn_ajax_kab() {
        $provinsi = DB::table("w_provinsi")->get();
        $access_token = Kasn::getaccesstoken();
        foreach($provinsi as $item) {
            echo $item->kode.' '.$item->nama.' '.$item->kasn_id.'<br />====================<br />';
            Kasn::getdaftarkabupaten($access_token, $item->kode, $item->nama, $item->kasn_id);
        }
    }
    function kasn_ajax_kec() {
        $provinsi = DB::table("w_kabupaten")->orderBy('kasn_kab_id', 'asc')->get();
        $access_token = Kasn::getaccesstoken();
        foreach($provinsi as $item) {
			$res=DB::table("w_provinsi")->select('nama')->where('kode','=',substr($item->kode, 0, 2))->orderBy('kode', 'desc')->first();
            echo $item->kode.' '.$item->nama.' '.$item->kasn_kab_id.'<br />====================<br />';
            Kasn::getdaftarkecamatan($access_token, $item->kode, $item->nama, $res->nama, $item->kasn_kab_id);
        }
    }
    function view($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
		$data=null;
        
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar($params);
            if($data){
                $id_jenislaporan=$data->id_jenislaporan;
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        $title = 'Kajian Awal';
        $main = 'm_kajianawal_view';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianawal.add').'/'.$ec_id_jenislaporan.'"';
        $id_jenislaporan = $id_jenislaporan;
		return view('be.m_kajianawal_view',compact('arrLink','title','id_jenislaporan','tambah','data'));
    }
    function trend($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar($params);
            if($data){
                $id_jenislaporan=$data->id_jenislaporan;
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $title = 'Kajian Awal';
        $main = 'm_kajianawal_trend';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianawal.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_kajianawal_trend',compact('arrLink','title','id_jenislaporan','tambah','data'));
    }
    function add_dokumen($id_jenislaporan=null,$id_kajianawal = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
		
        $paramsgetlap['id']=$id_kajianawal;
        $no='';$locus='';
        $stsfinal=0;
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianawal::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            $id_jenislaporan=$datalap->id_jenislaporan;
        }
        else{
            return redirect()->route('denied');
        }
        $stsfinal=$stsfinal;
        $title = 'Dokumen Kajian Awal <br><font class=subjudul>'.$no.'</font>';
        $main = 'm_kajianawaldok_add';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Kajian Awal",route('m_kajianawal.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
		$tambah=null;
        if(($locus==session('be_uwilayah')&&$stsfinal==0)||(session('be_urole')==3||$stsfinal==0)){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $paramskat1['level']=1;
		$data=null;
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar_dokumen($params);
        }
		return view('be.m_kajianawaldok_add',compact('arrLink','title','id_jenislaporan','tambah','data','no','locus','stsfinal','id_kajianawal'));
    }
    function add_dokumen_perbaikan($id_jenislaporan=null,$id_kajianawal = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
		
        $paramsgetlap['id']=$id_kajianawal;
        $no='';$locus='';
        $stsfinal=0;
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianawal::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            $id_jenislaporan=$datalap['id_jenislaporan'];
        }
        else{
            return redirect()->route('denied');
        }
        $stsfinal=$stsfinal;
        $id_kajianawal=$id_kajianawal;
        $title = 'Dokumen Perbaikan Laporan <br><font class=subjudul>'.$no.'</font>';
        $main = 'm_kajianawaldokperbaikan_add';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Perbaikan Laporan",route('m_kajianawal.daftar_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
		$tambah=null;
        if(($locus==session('be_uwilayah')&&$stsfinal==0)||(session('be_urole')==3||$stsfinal==0)){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $paramskat1['level']=1;
        $id_jenislaporan=$id_jenislaporan;
		$data=null;
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar_dokumen_perbaikan($params);
        }
		return view('be.m_kajianawaldokperbaikan_add',compact('arrLink','title','id_jenislaporan','tambah','data','no','locus','stsfinal','id_kajianawal'));
    }
    function view_dokumen($id_jenislaporan=null,$id_kajianawal = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
        
        $paramsgetlap['id']=$id_kajianawal;
        $no='';$locus='';$stsposisi='';
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianawal::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $id_jenislaporan=$datalap->id_jenislaporan;
            
            if(!General::cekaksesview($locus)){
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        $id_kajianawal=$id_kajianawal;
        $title = 'Dokumen Kajian Awal <br><font class=subjudul>'.$no.'</font>';
        $main = 'm_kajianawaldok_view';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Kajian Awal",route('m_kajianawal.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
        if($locus==session('be_uwilayah')||session('be_urole')==3){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $paramskat1['level']=1;
        $data=null;
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar_dokumen($params);
        }
		return view('be.m_kajianawaldok_view',compact('arrLink','title','id_jenislaporan','tambah','data','no','locus','stsposisi','id_kajianawal'));
    }
    function view_dokumen_perbaikan($id_jenislaporan=null,$id_kajianawal = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
        
        $paramsgetlap['id']=$id_kajianawal;
        $no='';$locus='';$stsposisi='';
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianawal::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $id_jenislaporan=$datalap['id_jenislaporan'];
            
            if(!General::cekaksesview($locus)){
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        $title = 'Dokumen Perbaikan Laporan <br><font class=subjudul>'.$no.'</font>';
        $main = 'm_kajianawaldokperbaikan_view';
        $arrLink=array(
                array("Kajian Awal",route('m_kajianawal.index').'/'.$ec_id_jenislaporan),
                array("Dokumen Perbaikan Laporan",route('m_kajianawal.daftar_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal),
                );
        if($locus==session('be_uwilayah')||session('be_urole')==3){
            $tambah = 'href="'.route('m_kajianawal.add_dokumen_perbaikan').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianawal.'"';
        }
        $paramskat1['level']=1;
        $data=null;
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianawal::daftar_dokumen_perbaikan($params);
        }
		return view('be.m_kajianawaldokperbaikan_view',compact('arrLink','title','id_jenislaporan','tambah','data','no','locus','stsposisi','id_kajianawal'));
    }
    function save_trend(Request $request){
        $admbasts=false;
        $id = getinp($request->id);
        $id_laporan = getinp($request->id_laporan);
        $id_jenislaporan = getinp($request->id_jenislaporan);
        if(!cekjenislapor2($id_jenislaporan)||!cekint($id_laporan)||!cekintnull($id)){
            return redirect()->route('denied');
        }
		DB::table("t_kajianawal_pelanggaran")->where('id_kajianawal',"=",$id)->delete();
		DB::table("t_kajianawal_pelanggaran_trend")->where('id_kajianawal',"=",$id)->delete();
		$data_trend=DB::table("m_kajianawala_kategori")->selectRaw('id,nama')->get();
        if($data_trend){
            foreach($data_trend as $item){
                $katawal=null;$trend=null;
                $katawal=$request->input('katawal'.$item->id);
                $trend=$request->input('trendpelanggaran'.$item->id);
                if($katawal){
                    DB::table('t_kajianawal_pelanggaran')->insert([
						'id_kajianawal'=>$id,
						'id_pelanggaran'=>$katawal,
						'create_by'=>session('be_uid'),
						'create_date'=>date("Y-m-d H:i:s")
					]);
					if($trend!=''){
                        $urut=1;
                        foreach($trend as $item_trend){
                            if($item_trend!=''){
                                DB::table('t_kajianawal_pelanggaran_trend')->insert([
									'id_kajianawal'=>$id,
									'id_pelanggaran'=>$katawal,
									'urut'=>$urut,
									'id_trend'=>$item_trend,
									'create_by'=>session('be_uid'),
									'create_date'=>date("Y-m-d H:i:s")
								]);
							}
                            $urut++;
                        }
                    }
                    if($item->id==3){
                        $admbasts=true;
                    }
                }
            }
        }
		$datalap=DB::table("t_laporan")->select('no')->where("id","=",$id_laporan)->first();
        $no=$datalap->no;
        $date=new DateTime();
        if($admbasts){
            $paramsupd['admbano'] = $request->admbano;
            $paramsupd['id']=$id;
			if (!empty($request->file('admbafile'))){
				$file=$request->file('admbafile');
				$file_name=$file->getClientOriginalName();
				$file_ext=$file->extension();
				$date=new DateTime();
				$namafile=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-admbafile',$file_ext);
				$paramsupd['admbafile'] = $namafile;
			}
			$data=M_kajianawal::add($paramsupd);
        }
        else{
            $paramsupd['admbano'] = '';
            $paramsupd['admbafile'] ='';
            $paramsupd['id']=$id;
            $data=M_kajianawal::add($paramsupd);
        }
        if($id_laporan!=""){
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'Kajian Awal::Dugaan Pelanggaran atau Trend Pelanggaran',
	               'aksi' => 'Update',
	               'note' => 'ID:'.$id.', Title: Pelaporan no '.$no.' sudah diubah data dugaan pelanggaran atau trend pelanggaran',
	               'ip' => $request->ip()
	           )
	        );
        }
		return redirect()->route('m_kajianawal.index',['id_jenislaporan'=>ec($id_jenislaporan)]);
    }
    function save(Request $request){
        $stslog=0;$admbasts=false;
        $id = getinp($request->id);
        $stsfinal = getinp($request->stsfinal);
        $params['id_trendpelanggaran']= getinp($request->trendpelanggaran);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_laporan'] = getinp($request->id_laporan);
        if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
            return redirect()->route('denied');
        }
        $params['note'] = getinpb($request->note);
        $params['id_kat1'] = getinp($request->id_kat1);
        $tgl_registrasi=getinp($request->tgl_registrasi);
        if ($tgl_registrasi!='') {
	        $tgl_registrasi=explode('/',$tgl_registrasi);
	        $tgl_registrasi=$tgl_registrasi[2].'-'.$tgl_registrasi[1].'-'.$tgl_registrasi[0].' 01:01:01';
	        $paramslaporan['id']=$params['id_laporan'];
	        $paramslaporan['tgl_registrasi']=$tgl_registrasi;
	        M_laporan::settglregistrasi($paramslaporan);
        }
        $params['id_kat2'] = getinp($request->id_kat2);
        $selwilpelimpahan = getinp($request->selwilpelimpahan);
        $locus_pelimpahan = $request->locus_pelimpahan;
        $noregmanual= getinp($request->noregmanualc);
        $kecamatan=getinp($request->kecamatanc);
        $actpelimpahan=0;
        
        $tanggal=date("Y-m-d H:i:s");
        $dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
        
        if($dt['operation']=='Ubah'){
            $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.no,b.locus,b.stsposisi,a.stsfinal')->first();
			if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $cekstsposisi=$datalap->stsposisi;
                $cekstsfinal=$datalap->stsfinal;
                
                if(!General::cekaksesedit($ceklocus)&&$cekstsfinal==0){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
			$datalap=DB::table("t_laporan")->selectRaw('no,locus,stsposisi')->where('id','=',$params['id_laporan'])->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $cekstsposisi=$datalap->stsposisi;
                
                if(!General::cekaksesedit($ceklocus)){
                    return redirect()->route('denied');
                }
                $paramslaporan['id']=$params['id_laporan'];
                $paramslaporan['stsposisi']='Kajian Awal';
                $paramslaporan['tgl_registrasi']=$tgl_registrasi;
                M_laporan::setposisi($paramslaporan);
                if ($tgl_registrasi!='') {
                	M_laporan::settglregistrasi($paramslaporan);
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        if(($params['id_kat2']==4||$params['id_kat2']==8||$params['id_kat2']==12)&&$params['id_laporan']!=""){
            if($selwilpelimpahan==1){
                $wilpelimpahan='0';
            }
            elseif($selwilpelimpahan==2){
                $wilpelimpahan=$request->prov;
            }
            elseif($selwilpelimpahan==3){
                $wilpelimpahan=$request->kabb;
            }
            elseif($selwilpelimpahan==4){
                $wilpelimpahan=$request->kabc;
            }
            if(!isset($wilpelimpahan)){
                $wilpelimpahan=$locus_pelimpahan;
            }
            $paramslap['id'] =$params['id_laporan'];
            $params['locus_pelimpahan']=$wilpelimpahan;
            if($params['id_kat2']==4){
                $actlaporan="dilimpahkan";
                $actlaporan1="Pelimpahan";
            }
            elseif($params['id_kat2']==8){
                $actlaporan="diteruskan";
                $actlaporan1="Penerusan";
            }
            elseif($params['id_kat2']==12){
                $actlaporan="diambilalih";
                $actlaporan1="Pengambilalihan";
            }
            
            if($stsfinal==1){
                $locus_hp='';$petugas_pelimpahan='';
				$data_pelimpahan=DB::table('m_user')->selectRaw('id_user,hp,stswa')->where('wilayah','=',$wilpelimpahan)->limit(1)->get();
                if($data_pelimpahan){
                    $no='';
                    $locusnma1='';
                    $locus1='';
                    $paramslap1["id"]=$params['id_laporan'];
                    $lap1=M_laporan::daftara($paramslap1);
                    if($lap1){
                        $no=$lap1->no;
                        $locus1=$lap1->locus;
                        $locusnma1=$lap1->locusnma;
                    }
                    
                    $id_laporan_tujuan=M_kajianawal::duplicateRecord('t_laporan','id',$params['id_laporan']);
                    $paramslap_tujuan["id"]=$id_laporan_tujuan;
                    if($selwilpelimpahan==4&&$noregmanual!=''){
                        $paramslap_tujuan['kecamatan']=$kecamatan;
                    }
                    $paramslap_tujuan['create_by'] =  session('be_uid');
                    $paramslap_tujuan['tgl_registrasi'] =  $tgl_registrasi;
                    $paramslap_tujuan['create_date'] =  $tanggal;
                    $paramslap_tujuan['locus']=$wilpelimpahan;
                    $paramslap_tujuan['edit_by_null'] =  1;
                    $paramslap_tujuan['edit_date_null'] =  1;
                    $paramslap_tujuan['stsvalid']=1;
                    $paramslap_tujuan['stsvalid_by']=session('be_uid');
                    $paramslap_tujuan['stsvalid_date']=$tanggal;
                    $paramslap_tujuan['stsposisi']='Terima '.$actlaporan1.' Laporan';
                    M_laporan::add($paramslap_tujuan);
                    
                    $paramslap_sub['id_sumber']=$params['id_laporan'];
                    $paramslap_sub['id_tujuan']=$id_laporan_tujuan;
                    $paramslap_sub['create_by'] = session('be_uid');
                    $paramslap_sub['create_date'] =  date("Y-m-d H:i:s");
                    M_kajianawal::duplicateSubLaporan($paramslap_sub);
                    
                    $paramslap_tuj["id"]=$id_laporan_tujuan;
                    $lap2=M_laporan::daftara($paramslap_tuj);
                    $locusnma2='';
                    if($lap2){
                        $locusnma2=$lap2['locusnma'];
                    }
                    
                    $paramslap_sumber["id"]=$params['id_laporan'];
                    $paramslap_sumber["locus"]=$locus1;
                    $paramslap_sumber["stslap"]=3;
                    $paramslap_sumber['stsposisi'] =  'Laporan '.$actlaporan;
                    $paramslap_sumber['edit_by'] =  session('be_uid');
                    $paramslap_sumber['edit_date'] =  $tanggal;
                    $paramslap_sumber['tgl_registrasi'] =  $tgl_registrasi;
                    $paramslap_sumber['keterangan'] =  'Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                    M_laporan::add($paramslap_sumber);
                    
					M_log::add(
			           array(
			               'stsfrom' => 2,
			               'modul' => 'Kajian Awal',
			               'aksi' => 'Pelimpahan laporan',
			               'note' => 'ID:'.$params['id_laporan'].', Title: Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2,
			               'ip' => $request->ip()
			           )
			        );
                    $stslog=1;
                    
                    $paramslap_tuj['id']=$id_laporan_tujuan;
                    $paramslap_tuj['keterangan'] =  'Pelaporan no '.$no.' '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                    M_laporan::add($paramslap_tuj);
                    
                    $actpelimpahan=1;
                    
                    $petugas_hp='';$petugas_id='';$petugas_stswa=0;
                    foreach($data_pelimpahan as $item){
                        $petugas_hp=$item->hp;
                        $petugas_id=$item->id_user;
                        $petugas_stswa=$item->stswa;
                        if($petugas_hp!=""&&$petugas_stswa==1){
                            $hp=$petugas_hp;
                            $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                            //$WhatsappService=new WhatsappService;
                            //$pesan='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                            //$WhatsappService->sendMessageToWhatsapp($hp,$pesan);
                        }
                        if($petugas_id!=""){
                            $paramsnotif['pesan']='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                            $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                            $paramsnotif['id_user']=$petugas_id;
                            M_notifikasia::add($paramsnotif);
                        }
                    }
					
                    $datalap=DB::table("t_laporan")->selectRaw('id_pelapor,no')->where('id','=',$params['id_laporan'])->first();
                    $id_pelapor='';$no='';
                    if($datalap){
                        $id_pelapor=$datalap->id_pelapor;
                        $no=$datalap->no;
                    }
                    if($id_pelapor!=""){
						$datapelapor=DB::table("t_user")->selectRaw('hp,email')->where('id_user','=',$id_pelapor)->first();
                        if($datapelapor){
                            $hp=$datapelapor->hp;
                            $email=$datapelapor->email;
                        }
                        if($hp!=""){
                            $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                            //$WhatsappService=new WhatsappService;
                            //$pesan='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                            //$WhatsappService->sendMessageToWhatsapp($hp,$pesan);
                        }
                        if($email!=''){
                            $paramsemail['toemail']=$email;
                            $paramsemail['subyek']='Pelaporan no '.$no.' sudah '.$actlaporan.'';
                            $paramsemail['pesan']='Diberitahukan kepada Pelapor bahwa pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2.'<br><br>Terimakasih';
                            kirim_email($paramsemail);
                        }
                        $paramsnotif['pesan']='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                        $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                        $paramsnotif['id_user']=$id_pelapor;
                        M_notifikasi::add($paramsnotif);
                    }
                    
                    $hp='';$petugas='';
					$locus_login=DB::table("t_laporan")->select('locus')->where('id','=',$params['id_laporan'])->first()->locus;
					$data_melimpahkan=DB::table("m_user")->select('id_user','hp')->where('wilayah','=',$locus_login)->where('jabatan','=','Pimpinan')->get();
                    if($data_melimpahkan){
                        foreach($data_melimpahkan as $item){
                            $hp=$item->hp;
                            $petugas=$item->id_user;
                            if($hp!=""){
                                $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                                //$WhatsappService=new WhatsappService;
                                //$pesan='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                                //$WhatsappService->sendMessageToWhatsapp($hp,$pesan);
                            }
                            $paramsnotif['pesan']='Pelaporan no '.$no.' sudah '.$actlaporan.' dari '.$locusnma1.' ke '.$locusnma2;
                            $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                            $paramsnotif['id_user']=$petugas;
                            M_notifikasia::add($paramsnotif);
                        }
                    }
                    if($paramsnotif["pesan"]!=""){
                        M_log::add(
				           array(
				               'stsfrom' => 2,
                               'modul' => 'Kajian Awal',
                               'aksi' => $dt['operation'],
                               'note' => $paramsnotif["pesan"],
				               'ip' => $request->ip()
				           )
				        );
                        $stslog=1;
                    }
                }
                else{
                    $stsfinal=0;
					return redirect()->route('m_kajianawal.showerr',['id_jenislaporan'=>ec($id_jenislaporan)]);
                    exit;
                }
            }
        }
        if($stsfinal==1){
            if($params['id_kat2']==5||$params['id_kat2']==11||$params['id_kat1']==3||$params['id_kat1']==9||$params['id_kat1']==10){
                $pesan='';$pesanaksi='';
				$datalap=DB::table("t_laporan")->select('id_pelapor','no')->where('id','=',$params['id_laporan'])->first();
                $id_pelapor='';$no='';
                if($datalap){
                    $id_pelapor=$datalap->id_pelapor;
                    $no=$datalap->no;
                }
                if($params['id_kat2']==5){
                    $pesan='Pelaporan dengan no '.$no.' sudah diregistrasi.';
                    $pesanaksi='Registrasi';
                }
                if($params['id_kat2']==11){
                    $pesan='Pelaporan dengan no '.$no.' sudah diregistrasi di tempat dilimpahkan/diteruskan.';
                    $pesanaksi='Registrasi';
                }
                elseif($params['id_kat1']==3){
                    $pesan='Pelaporan dengan no '.$no.' tidak diregistrasi';
                    $pesanaksi='Tidak diregistrasi';
                }
                elseif($params['id_kat1']==9){
                    $pesan='Pelaporan dengan no '.$no.' dicabut dan tidak diregistrasi';
                    $pesanaksi='Dicabut dan tidak diregistrasi';
                }
                elseif($params['id_kat1']==10){
                    $pesan='Pelaporan dengan no '.$no.' tidak diregistrasi karena sudah ditangani';
                    $pesanaksi='Tidak diregistrasi';
                }
                if($id_pelapor!=""){
					$datapelapor=DB::table("t_user")->select('hp','email')->where('id_user','=',$id_pelapor)->first();
                    if($datapelapor){
                        $hp=$datapelapor->hp;
                        $email=$datapelapor->email;
                    }
                    if($hp!=""){
                        $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                        //$WhatsappService=new WhatsappService;
                        //$WhatsappService->sendMessageToWhatsapp($hp,$pesan);
                    }
                    if($email!=''){
                        $paramsemail['toemail']=$email;
                        $paramsemail['subyek']=$pesan;
                        $paramsemail['pesan']='Diberitahukan kepada Pelapor bahwa '.$pesan.'.<br><br>Terimakasih';
                        kirim_email($paramsemail);
                    }
                }
                $hp='';$petugas='';
				$locus_login=DB::table("t_laporan")->select('locus')->where('id','=',$params['id_laporan'])->first()->locus;
				$data_melimpahkan=DB::table("m_user")->select('id_user','hp')->where('wilayah','=',$locus_login)->where('jabatan','=','Pimpinan')->get();
                if($data_melimpahkan){
                    foreach($data_melimpahkan as $item){
                        $hp=$item->hp;
                        $petugas=$item->id_user;
                        if($hp!=""){
                            $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                            //$WhatsappService=new WhatsappService;
                            //$WhatsappService->sendMessageToWhatsapp($hp,$pesan);
                        }
                        $paramsnotif['pesan']=$pesan;
                        $paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
                        $paramsnotif['id_user']=$petugas;
                        M_notifikasia::add($paramsnotif);
                    }
                }
                if($pesan!=""){
                    M_log::add(
			           array(
			               'stsfrom' => 2,
                           'modul' => 'Kajian Awal',
                           'aksi' => $dt['operation'],
                           'note' => $pesan,
			               'ip' => $request->ip()
			           )
			        );
                    $stslog=1;
                }
            }
        }
        $params['sel_pelimpahan'] = $selwilpelimpahan;
        $params['noregmanual'] = $noregmanual;
        $params['kecamatan'] = $kecamatan;
        if($selwilpelimpahan!=4&&$selwilpelimpahan!=8&&$selwilpelimpahan!=12){
            $params['kecamatan'] ='';
        }
        $params['stsfinal'] = $stsfinal;
        $params['create_by'] =  session('be_uid');
        $params['create_date'] =  date("Y-m-d H:i:s");
        $data=M_kajianawal::add($params);
        if($data){
            $id=$data;
        }
		DB::table("t_kajianawal_pelanggaran")->where('id_kajianawal',"=",$id)->delete();
		DB::table("t_kajianawal_pelanggaran_trend")->where('id_kajianawal',"=",$id)->delete();
		$data_trend=DB::table("m_kajianawala_kategori")->select('id','nama')->get();
        if($data_trend){
            foreach($data_trend as $item){
                $katawal=null;$trend=null;
                $katawal=$request->input('katawal'.$item->id);
                $trend=$request->input('trendpelanggaran'.$item->id);
                if($katawal){
                    DB::table('t_kajianawal_pelanggaran')->insert([
						'id_kajianawal'=>$id,
						'id_pelanggaran'=>$katawal,
						'create_by'=>session('be_uid'),
						'create_date'=>date("Y-m-d H:i:s")
					]);
					if($trend!=''){
                        $urut=1;
                        foreach($trend as $item_trend){
                            if($item_trend!=''){
                                DB::table('t_kajianawal_pelanggaran_trend')->insert([
									'id_kajianawal'=>$id,
									'id_pelanggaran'=>$katawal,
									'urut'=>$urut,
									'id_trend'=>$item_trend,
									'create_by'=>session('be_uid'),
									'create_date'=>date("Y-m-d H:i:s")
								]);
							}
                            $urut++;
                        }
                    }
                    if($item->id==3){
                        $admbasts=true;
                    }
                }
            }
        }
        if($stslog==0&&$params['id_kat1']!=""){
            $kat1_nama=DB::table("m_kajianawal_kategori")->select('nama')->where('id','=',$params['id_kat1'])->first()->nama;
			M_log::add(
	           array(
                   'stsfrom' => 2,
                   'modul' => 'Kajian Awal',
                   'aksi' => $dt['operation'],
                   'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.' berada pada kategori '.$kat1_nama,
	               'ip' => $request->ip()
	           )
	        );
        }
        if(($params['id_kat2']==5||$params['id_kat2']==11)&&$stsfinal==1){
            $paramsgetlap['id']=$id;
            
            $datano =M_kajianawal::getlaporan($paramsgetlap);
            if($datano){
                $no=$datano->no;
                $locus_m=$datano->locus;
                $arr=explode('/',$no);
                if($locus_m==$arr[4]){
                    $no_registrasi_non_adm='';$no_registrasi_adm='';
					$query4x=DB::table("t_kajianawal_pelanggaran as a")->join('m_kajianawala_kategori as b','a.id_pelanggaran','=','b.id')
							 ->where('a.id_kajianawal','=',$id)
							 ->selectRaw('a.id_pelanggaran,b.nama')->get();
                    if ($query4x->count() > 0){
                        foreach($query4x as $row){
                            if (($row->id_pelanggaran==1)||($row->id_pelanggaran==2)||($row->id_pelanggaran==4)) {
                                if ($no_registrasi_non_adm=='') {
                                    $no_registrasi_non_adm=Nomor::getnourutreg($no, $params['id_laporan']);
                                }
                            }
                            if ($row->id_pelanggaran==3) {
                                $no_registrasi_adm=Nomor::getnourutreg2($no, $params['id_laporan']);
                                
                            }
                        }
                    }
                    
                    $paramslap['no_registrasi']=$no_registrasi_non_adm;
                if ($id_jenislaporan==2){
                    $paramslap['no_registrasi2']=$no_registrasi_adm;
                }else
                $paramslap['no_registrasi2']='';
                }
                else{
                    $no_registrasi_non_adm='';$no_registrasi_adm='';
					$query4x=DB::table("t_kajianawal_pelanggaran as a")->join('m_kajianawala_kategori as b','a.id_pelanggaran','=','b.id')
							 ->where('a.id_kajianawal','=',$id)
							 ->selectRaw('a.id_pelanggaran,b.nama')->get();
                    if ($query4x->count() > 0) {
                        foreach($query4x as $row) {
                            if (($row->id_pelanggaran==1)||($row->id_pelanggaran==2)||($row->id_pelanggaran==4)) {
                                if ($no_registrasi_non_adm=='') {
                                    $no_registrasi_non_adm=Nomor::getnourutregpelimpahan($no,$locus_m, $params['id_laporan']);
                                }
                            }
                            if ($row->id_pelanggaran==3) {
                                $no_registrasi_adm=Nomor::getnourutregpelimpahan2($no,$locus_m, $params['id_laporan']);
                            }
                        }
                    }
                    
                    $paramslap['no_registrasi']=$no_registrasi_non_adm;
                if ($id_jenislaporan==2){
                    $paramslap['no_registrasi2']=$no_registrasi_adm;
                }else
                $paramslap['no_registrasi2']='';
                    //$paramslap['no_registrasi']=Nomor::getnourutregpelimpahan($no,$locus_m, $params['id_laporan']);
                }
            }
            $paramslap['id']=$params['id_laporan'];
            //$paramslap['no_registrasi']=substr($no,0,4).'.REG/'.substr($no,5,strlen($no));
            $paramslap['stslap']=1;
            $paramslap['stslap_by'] =  session('be_uid');
            $paramslap['stslap_date'] =  date("Y-m-d H:i:s");
            $paramslap['stsposisi']='Pelaporan diregister';
            M_laporan::add($paramslap);
            M_log::add(
	           array(
                   'stsfrom' => 2,
                   'modul' => 'Kajian Awal',
                   'aksi' => 'Pelaporan diregister',
                   'note' => 'ID:'.$id.', Title: Pelaporan no '.$no.' sudah diregister',
	               'ip' => $request->ip()
	           )
	        );
            $stslog=1;
        }
        if($params['id_kat1']==3&&$stsfinal==1){
            $paramslap['id']=$params['id_laporan'];
            $paramslap['stslap']=2;
            $paramslap['stslap_by'] =  session('be_uid');
            $paramslap['stslap_date'] =  date("Y-m-d H:i:s");
            $paramslap['stsposisi']='Pelaporan tidak diregister karena tidak memenuhi formil/materil';
            M_laporan::add($paramslap);
            
            M_log::add(
	           array(
                   'stsfrom' => 2,
                   'modul' => 'Kajian Awal',
                   'aksi' => 'Pelaporan tidak diregister',
                   'note' => 'ID:'.$params['id_laporan'].', Title: Pelaporan no '.$no.' tidak diregister',
	               'ip' => $request->ip()
	           )
	        );
            $stslog=1;
        }
        if($params['id_kat1']==9&&$stsfinal==1){
            $paramslap['id']=$params['id_laporan'];
            $paramslap['stslap']=2;
            $paramslap['stslap_by'] =  session('be_uid');
            $paramslap['stslap_date'] =  date("Y-m-d H:i:s");
            $paramslap['stsposisi']='Pelaporan tidak diregister karena dicabut';
            M_laporan::add($paramslap);
            
            M_log::add(
	           array(
                   'stsfrom' => 2,
                   'modul' => 'Kajian Awal',
                   'aksi' => 'Pelaporan dicabut dan tidak diregister',
                   'note' => 'ID:'.$params['id_laporan'].', Title: Pelaporan no '.$no.' dicabut dan tidak diregister',
	               'ip' => $request->ip()
	           )
	        );
            $stslog=1;
        }
        if($params['id_kat1']==10&&$stsfinal==1){
            $paramslap['id']=$params['id_laporan'];
            $paramslap['stslap']=2;
            $paramslap['stslap_by'] =  session('be_uid');
            $paramslap['stslap_date'] =  date("Y-m-d H:i:s");
            $paramslap['stsposisi']='Pelaporan tidak diregister karena sudah ditangani';
            M_laporan::add($paramslap);
            
            M_log::add(
	           array(
                   'stsfrom' => 2,
                   'modul' => 'Kajian Awal',
                   'aksi' => 'Pelaporan tidak diregister karena sudah ditangani',
                   'note' => 'ID:'.$params['id_laporan'].', Title: Pelaporan no '.$no.' tidak diregister',
	               'ip' => $request->ip()
	           )
	        );
            $stslog=1;
        }
        if($params['id_kat1']==7){
			$datalap=DB::table("t_laporan")->select('id_pelapor','no')->where('id','=',$params['id_laporan'])->first();
            $id_pelapor='';$no='';
            if($datalap){
                $id_pelapor=$datalap->id_pelapor;
                $no=$datalap->no;
            }
            if($id_pelapor!=""){
				$hp=DB::table("t_user")->select('hp')->where('id_user','=',$id_pelapor)->first()->hp;
                if($hp!=""){
                    $hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
                    //$WhatsappService=new WhatsappService;
                    //$WhatsappService->sendMessageToWhatsapp($hp, 'Pelaporan dengan no '.$no.' harap dilengkapi dokumennya dan diserahkan kelengkapan dokumennya ke kantor Bawaslu paling lambat 2x24 jam. Informasi dokumen yang harus dilengkapi bisa dilihat pada aplikasi SIGAPLapor pada modul Kajian Awal');
                }
            }
        }
		$no=DB::table("t_laporan")->select('no')->where('id','=',$params['id_laporan'])->first()->no;
        $date=new DateTime();
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_kajianawal::add($paramsupd);
		}
        if($admbasts){
            $paramsupd['admbano'] = $request->admbano;
            $paramsupd['id']=$id;
			
			if (!empty($request->file('admbafile'))){
				$file=$request->file('admbafile');
				$file_name=$file->getClientOriginalName();
				$file_ext=$file->extension();
				$date=new DateTime();
				$namafile=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-admbafile',$file_ext);
				$paramsupd['admbafile'] = $namafile;
			}
            $data=M_kajianawal::add($paramsupd);
        }
        else{
            $paramsupd['admbano'] = '';
            $paramsupd['admbafile'] ='';
            $paramsupd['id']=$id;
            $data=M_kajianawal::add($paramsupd);
        }
		if (!empty($request->file('dokumen_kat'))){
			$file=$request->file('dokumen_kat');
            $namafile=NULL;
            if($params['id_kat1']==2){
                $katfile = 'dokumen_registrasi';
            }
            elseif($params['id_kat1']==3){
                $katfile = 'dokumen_unregistrasi';
            }
            elseif($params['id_kat1']==7){
                $katfile = 'dokumen_lengkapi';
            }
            elseif($params['id_kat1']==9){
                $katfile = 'dokumen_dicabut';
            }
            elseif($params['id_kat1']==10){
                $katfile = 'dokumen_unregistrasi_sdh_ditangani';
            }
			$namafiles=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-'.$katfile);
            if($params['id_kat1']==2){
                $paramsupd['dok_reg'] = $namafiles;
            }
            elseif($params['id_kat1']==3){
                $paramsupd['dok_unreg'] = $namafiles;
            }
            elseif($params['id_kat1']==7){
                $paramsupd['dok_lengkapidokumen'] = $namafiles;
            }
            elseif($params['id_kat1']==9){
                $paramsupd['dok_dicabut'] = $namafiles;
            }
            elseif($params['id_kat1']==10){
                $paramsupd['dok_unreg_sdh_ditangani'] = $namafiles;
            }
            $paramsupd['id']=$id;
            $data=M_kajianawal::add($paramsupd);
        }
        if(isset($id)){
            if(isset($paramsupd['dokumen'])){
                $paramsdokumen['id_kajianawal'] = $id;
                $paramsdokumen['dokumen']=$paramsupd['dokumen'];
                $paramsdokumen['note']=$params['note'];
                $paramsdokumen['create_by'] =  session('be_uid');
                $paramsdokumen['create_date'] =  date("Y-m-d H:i:s");
                $data=M_kajianawal::add_dokumen($paramsdokumen);
            }
        }
        if($actpelimpahan==1){
            $id_kajianawal_tujuan=M_kajianawal::duplicateRecord('t_kajianawal','id',$id);
            $paramslap_k['id'] = $id_kajianawal_tujuan;
            $paramslap_k['id_laporan'] = $id_laporan_tujuan;
            $paramslap_k['id_kat1_null'] = 1;
            $paramslap_k['id_kat2_null'] = 1;
            $paramslap_k['id_kat3_null'] = 1;
            $paramslap_k['stsfinal_nol'] = 1;
            $paramslap_k['kecamatan_null'] = 1;
            $paramslap_k['noregmanual_null'] = 1;
            $paramslap_k['sel_pelimpahan_null'] = 1;
            $paramslap_k['locus_pelimpahan_null'] = 1;
            $paramslap_k['create_by'] = session('be_uid');
            $paramslap_k['create_date'] =  date("Y-m-d H:i:s");
            $paramslap_k['edit_by_null'] = 1;
            $paramslap_k['edit_date_null'] = 1;
            $data=M_kajianawal::add($paramslap_k);
            
            $paramslap_subk['id_sumber']=$id;
            $paramslap_subk['id_tujuan']=$id_kajianawal_tujuan;
            $paramslap_subk['create_by'] = session('be_uid');
            $paramslap_subk['create_date'] =  date("Y-m-d H:i:s");
            M_kajianawal::duplicateSubKajianAwal($paramslap_subk);
        }
		return redirect()->route('m_kajianawal.index',['id_jenislaporan'=>ec($id_jenislaporan)]);
    }
    function save_dokumen(Request $request){
        $id = getinp($request->id);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_kajianawal'] = getinp($request->id_kajianawal);
        $params['note'] = getinp($request->note);
        $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$params['id_kajianawal'])
					 ->selectRaw('b.no,b.locus,b.stsposisi,a.stsfinal')->first();
		if(!empty($datalap)){
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            
            if(!General::cekaksesedit($ceklocus)&&$stsfinal==0){
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        if($params['id']!=""){
            $dt['operation']='Ubah';
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        else{
            $dt['operation']='Tambah';
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_kajianawal::add_dokumen($params);
        $paramsupd['dokumen']=null;
        if($data){
            $id=$data;
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal::Dokumen',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']).' dokumen '.$params['note'],
               'ip' => $request->ip()
           )
        );
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=NULL;
			$namafile=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_kajianawal::add_dokumen($paramsupd);
		}
        if(isset($id)){
            $paramsupdkajian['id'] = $params['id_kajianawal'];
            $paramsupdkajian['note'] = $params['note'];
            $paramsupdkajian['dokumen']=$paramsupd['dokumen'];
            $paramsupdkajian['edit_by'] =  session('be_uid');
            $paramsupdkajian['edit_date'] =  date("Y-m-d H:i:s");
            $data=M_kajianawal::add($paramsupdkajian);
        }
        echo route('m_kajianawal.daftar_dokumen').'/'.ec($id_jenislaporan).'/'.ec($params['id_kajianawal']);
    }
    function save_dokumen_perbaikan(){
        $id = getinp($request->id);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_kajianawal'] = getinp($request->id_kajianawal);
        $params['note'] = getinp($request->note);
        $params['tgl'] = getinp($request->tgl);
        $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$params['id_kajianawal'])
					 ->selectRaw('b.no,b.locus,b.stsposisi,a.stsfinal')->first();
		if(!empty($datalap)){
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            
            if(!General::cekaksesedit($ceklocus)&&$stsfinal==0){
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        if($params['id']!=""){
            $dt['operation']='Ubah';
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        else{
            $dt['operation']='Tambah';
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_kajianawal::add_dokumen_perbaikan($params);
        $paramsupd['dokumen']=null;
        if($data){
            $id=$data;
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal::Dokumen Perbaikan Laporan',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']).' dokumen laporan'.$params['note'],
               'ip' => $request->ip()
           )
        );
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=NULL;
			$namafile=aksi_upload($file,'kajianawal',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_kajianawal::add_dokumen_perbaikan($paramsupd);
		}
		return redirect()->route('m_kajianawal.daftar_dokumen_perbaikan',['id_jenislaporan'=>ec($id_jenislaporan),'id_kajianawal'=>ec($params['id_kajianawal'])]);
    }
    function del($id_jenislaporan=null,$id = NULL,Request $request){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi,a.stsfinal')->first();
		$no='';
        if(!empty($datalap)){
            $idlap=$datalap->id;
            $id_jenislaporan=$datalap->id_jenislaporan;
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            
            if(General::cekaksesedit($ceklocus)&&$stsfinal==0){
                //do nothing
            }
            else{
			
			echo 'ccc';
			die();
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal::Dokumen Perbaikan Laporan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
        $data=M_kajianawal::del($id);
        
        $params['id']=$idlap;
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        $params['stsposisi']='Validasi Pelaporan';
        M_laporan::add($params);
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
        return redirect()->route('m_kajianawal.index',['id_jenislaporan'=>ec($id_jenislaporan)]);
    }
    function del_dokumen($id_jenislaporan=null,$id_kajianawal=NULL, $id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
        
        $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id_kajianawal)
					 ->selectRaw('b.no,b.locus,b.stsposisi,a.stsfinal')->first();
		$no='';
        if(!empty($datalap)){
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            
            if(General::cekaksesedit($ceklocus)&&$stsfinal==0){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        $dok_note=DB::table('t_kajianawal_dokumen')->select('note')->where('id','=',$id)->first()->note;
        
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal::Dokumen',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.', dokumen '.$dok_note.' sudah dihapus ',
               'ip' => $request->ip()
           )
        );
        $data=M_kajianawal::del_dokumen($id);
        
        $doklast=$this->db->select('*')->where('id_kajianawal',$id_kajianawal)->from('t_kajianawal_dokumen',0,1)->order_by('id', 'desc')->limit(1)->get()->row();
        if($doklast){
            $paramskajian['note']=$doklast->note;
            $paramskajian['dokumen']=$doklast->dokumen;
        }
        else{
            $paramskajian['note']=null;
            $paramskajian['dokumen']=null;
        }
        $paramskajian['id']=$id_kajianawal;
        $paramskajian['edit_by'] =  session('be_uid');
        $paramskajian['edit_date'] =  date("Y-m-d H:i:s");
        M_kajianawal::upd($paramskajian);
		
        return redirect()->route('m_kajianawal.daftar_dokumen',['id_jenislaporan'=>ec_id_jenislaporan,'ec_id_kajianawal'=>ec_id_kajianawal])->with('success',' Hapus Pelaporan Berhasil');
    }
    function del_dokumen_perbaikan($id_jenislaporan=null,$id_kajianawal=NULL, $id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianawal))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianawal=$id_kajianawal;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianawal=dc($id_kajianawal);
        $id=dc($id);
        
        $datalap=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id_kajianawal)
					 ->selectRaw('b.no,b.locus,b.stsposisi,a.stsfinal')->first();
		$no='';
        if(!empty($datalap)){
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $stsfinal=$datalap->stsfinal;
            
            if(General::cekaksesedit($ceklocus)&&$stsfinal==0){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $dok_note=DB::table('t_kajianawal_dokumen_perbaikan')->select('note')->where('id','=',$id)->first()->note;
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Awal::Dokumen Perbaikan Laporan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Kajian awal dengan pelaporan no '.$no.', dokumen Perbaikan Laporan '.$dok_note.' sudah dihapus ',
               'ip' => $request->ip()
           )
        );
		
        $data=M_kajianawal::del_dokumen_perbaikan($id);
        return redirect()->route('m_kajianawal.daftar_dokumen_perbaikan',['id_jenislaporan'=>$ec_id_jenislaporan,'id_kajianawal'=>$ec_id_kajianawal])->with('success',' Hapus Pelaporan Berhasil');
    }
}
