<?php
  
namespace App\Http\Controllers\Auth;
  
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Session;
use App\Models\Admin;
use Hash;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
  
class BeController extends Controller
{
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function index(): View
    {
        return view('be.auth.m_login');
    }  
      
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function registration(): View
    {
        //return view('be.auth.registration');
		return view('be.auth.registration');
    }
	public function reloadCaptcha()
    {
        return response()->json(['captcha'=> captcha_img('flat')]);
    }
    public function postLogin(Request $request): RedirectResponse
    {
        $request->validate([
            'nm_user' => 'required',
            'password' => 'required',
			'captcha' => 'required|captcha'
        ]);
		$nm_user=$request->nm_user;
		$password=$request->password;
		
		$user = Admin::where([ 
	        'nm_user'  => $nm_user
	    ])->first();
		$sts=false;
		if($user){
			if($user->password==sha1($password)){
				$sts=true;
				$user->password=bcrypt($password);
				$user->save();
			}
			if(Hash::check($password,$user->password)){
				$sts=true;
			}
			if($sts){
				$credentials = $request->only('nm_user', 'password');
				$s=Auth::guard('admin')->attempt($credentials);
				if($s){
					$id=Auth::guard('admin')->user()->id_user;
					$data=Admin::cekuser($id);
					if($data){
						session(['be_uid' => $id]);
						foreach($data as $item){
							session(['be_uname' => $item->nama]);
							session(['be_urole' => $item->id_role]);
							session(['be_uposisi' => $item->posisi]);
							session(['be_uwilayah' => $item->wilayah]);
							session(['be_uprovinsi' => $item->provinsi]);
							session(['be_uprovinsinm' => $item->provinsinm]);
							session(['be_ukabkota' => $item->kabkota]);
							session(['be_ukabkotanm' => $item->kabkotanm]);
							if($item->foto!=NULL){
								session(['foto' => asset('media/uploads/foto/'.$item->foto)]);
							}
							else{
								session(['foto' => asset('media/uploads/foto/profil.jpg')]);
							}
						}
					}
					//die();
					return redirect()->intended('m_home');
				}
				else{
					return redirect("be")->withError('Invalid Login');
				}
			}
			else{
				return redirect("be")->withError('Invalid Login');
			}
		}
        return redirect("be")->withError('Invalid Login');
    }
      
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function postRegistration(Request $request): RedirectResponse
    {  
        $request->validate([
            'nama' => 'required',
            'nm_user' => 'required|unique:users',
            'sandi' => 'required|min:6',
        ]);
           
        $data = $request->all();
        $user = $this->create($data);
            
        Auth::login($user); 

        return redirect("dashboard")->withSuccess('Great! You have Successfully loggedin');
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function dashboard()
    {
        if(Auth::check()){
            return view('be.auth.dashboard');
        }
  
        return redirect("be")->withSuccess('Opps! You do not have access');
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function create(array $data)
    {
      return User::create([
        'nama' => $data['nama'],
        'nm_user' => $data['nm_user'],
        'sandi' => Hash::make($data['sandi'])
      ]);
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function logout(): RedirectResponse
    {
        Session::flush();
        Auth::logout();
  
        return Redirect('be');
    }
}