<?php
	if (!function_exists('pretty_date')) {
	    function pretty_date($date = '', $format = '', $timezone = TRUE) {
	        $date_str = strtotime($date);
	
	        if (empty($format)) {
	            $date_pretty = date('l, d/m/Y H:i', $date_str);
	        } else {
	            $date_pretty = date($format, $date_str);
	        }
	
	        if ($timezone) {
	            $date_pretty .= ' WIB';
	        }
	
	        $date_pretty = str_replace('Sunday', 'Minggu', $date_pretty);
	        $date_pretty = str_replace('Monday', 'Senin', $date_pretty);
	        $date_pretty = str_replace('Tuesday', 'Selasa', $date_pretty);
	        $date_pretty = str_replace('Wednesday', 'Rabu', $date_pretty);
	        $date_pretty = str_replace('Thursday', 'Kamis', $date_pretty);
	        $date_pretty = str_replace('Friday', 'Jumat', $date_pretty);
	        $date_pretty = str_replace('Saturday', 'Sabtu', $date_pretty);
	
	        $date_pretty = str_replace('January', 'Januari', $date_pretty);
	        $date_pretty = str_replace('February', 'Februari', $date_pretty);
	        $date_pretty = str_replace('March', 'Maret', $date_pretty);
	        $date_pretty = str_replace('April', 'April', $date_pretty);
	        $date_pretty = str_replace('May', 'Mei', $date_pretty);
	        $date_pretty = str_replace('June', 'Juni', $date_pretty);
	        $date_pretty = str_replace('July', 'Juli', $date_pretty);
	        $date_pretty = str_replace('August', 'Agustus', $date_pretty);
	        $date_pretty = str_replace('September', 'September', $date_pretty);
	        $date_pretty = str_replace('October', 'Oktober', $date_pretty);
	        $date_pretty = str_replace('November', 'November', $date_pretty);
	        $date_pretty = str_replace('December', 'Desember', $date_pretty);
	        return $date_pretty;
	    }
	}
	
	if (!function_exists('isinp')) {
		function isinp($p){
			$s=false;
			if(isset($p)){
				if(is_string($p)){
					if($p!=""){
						$s=true;
					}
				}
				else{
					$s=true;
				}
			}
			return $s;
		}
	}
	if (!function_exists('getinp')) {
		function getinp($p){
			$s="";
			if($p!=""){
				$s=($p!=""?repstr($p):"");
			}
			return $s;
		}
	}
	if (!function_exists('getinpa')) {
		function getinpa($p){
			$s=NULL;
			if($p!=""){
				$s=$p;
			}
			return $s;
		}
	}
	if (!function_exists('getinpb')) {
		function getinpb($p){
			$s=NULL;
			if($p!=""){
				$s=($p!=""?repstr($p):NULL);
			}
			return $s;
		}
	}
	if (!function_exists('getinpc')) {
		function getinpc($p){
			$s="";
			if($p!=""){
				$s=($p!=""?repstra($p):"");
			}
			return $s;
		}
	}
	if (!function_exists('formatnumberdb')) {
		function formatnumberdb($p){
			$s="";
			if($p!=""){
				$s=($p!=""?str_replace(',','.',str_replace('.','',$p)):'');
			}
			return $s;
		}
	}
	if (!function_exists('formatnumberapp')) {
		function formatnumberapp($p,$a=0){
			$s="";
			$p=(string) $p;
			if($p!=""){
				$s=number_format($p,$a,',','.');
			}
			return $s;
		}
	}
	if (!function_exists('printby')) {
		function printby($b,$p){
			$s="";
			if($b=="pdf"){
				$s=formatnumberapp($p);
			}
			else if($b="exl"){
				$s=$p;
			}
			return $s;
		}
	}
	
	if (!function_exists('InggrisTglTime')) {
		function InggrisTglTime($tanggal){
			$awal=null;
			if($tanggal!=""){
				$tgl=substr($tanggal,0,2);
				$bln=substr($tanggal,3,2);
				$thn=substr($tanggal,6,4);
				$time=substr($tanggal,11,5);
				if($time==''){
					$time="00:00";
				}
				$awal="$thn-$bln-$tgl $time:00";
			}
			return $awal;
		}
	}
	
	if (!function_exists('InggrisTgl')) {
		function InggrisTgl($tanggal){
			$awal="";
			if($tanggal!=""){
				$tgl=substr($tanggal,0,2);
				$bln=substr($tanggal,3,2);
				$thn=substr($tanggal,6,4);
				$awal="$thn-$bln-$tgl";
			}
			return $awal;
		}
	}
	if (!function_exists('InggrisTglDB')) {
		function InggrisTglDB($tanggal){
			$awal=null;
			if($tanggal!=""){
				$tgl=substr($tanggal,0,2);
				$bln=substr($tanggal,3,2);
				$thn=substr($tanggal,6,4);
				$awal="$thn-$bln-$tgl";
			}
			return $awal;
		}
	}
	
	if (!function_exists('IndonesiaTgl')) {
		function IndonesiaTgl($tanggal){
			$awal="";
			if($tanggal!=""){
				$tgl=substr($tanggal,8,2);
				$bln=substr($tanggal,5,2);
				$thn=substr($tanggal,0,4);
				$awal="$tgl/$bln/$thn";
			}
			return $awal;
		}
	}
	
	if (!function_exists('IndonesiaTglTime')) {
		function IndonesiaTglTime($tanggal){
			$awal="";
			if($tanggal!=""){
				$tgl=substr($tanggal,8,2);
				$bln=substr($tanggal,5,2);
				$thn=substr($tanggal,0,4);
				$time=substr($tanggal,11,5);
				if($time==''){
					$time="00:00";
				}
				$awal="$tgl/$bln/$thn $time:00";
			}
			return $awal;
		}
	}
	
	if (!function_exists('namabulan')) {
		function namabulan($p){
			$s="";
			if($p!=""){
				$bulan = array(
	                1 => 'JANUARI',
	                2 => 'FEBRUARI',
	                3 => 'MARET',
	                4 => 'APRIL',
	                5 => 'MEI',
	                6 => 'JUNI',
	                7 => 'JULI',
	                8 => 'AGUSTUS',
	                9 => 'SEPTEMBER',
	                10 => 'OKTOBER',
	                11 => 'NOVEMBER',
	                12 => 'DESEMBER',
	       	 	);
				$s=$bulan[intval($p)];
			}
			return $s;
		}
	}
	
	if (!function_exists('konversi_tanggal')) {
		function konversi_tanggal($format, $tanggal="now", $bahasa="id"){
		 $en=array("Sun","Mon","Tue","Wed","Thu","Fri","Sat","Jan","Feb",
		 "Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
		 
		 $id=array("Minggu","Senin","Selasa","Rabu","Kamis","Jumat","Sabtu",
		 "Januari","Pebruari","Maret","April","Mei","Juni","Juli","Agustus","September",
		 "Oktober","Nopember","Desember");
		 
		 $idshort=array("Minggu","Senin","Selasa","Rabu","Kamis","Jumat","Sabtu",
		 "Jan","Feb","Mar","Apr","Mei","Jun","Jul","Agu","Sep",
		 "Okt","Nop","Des");
		 
		 // tambahan untuk bahasa prancis
		 // sumber http://w.blankon.in/6V
		 $fr = array("dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi",
		 "janvier","février","mars","avril","Mei","mai","juillet","aoùt","septembre",
		 "octobre","novembre","décembre");
		 
		 // mengganti kata yang berada pada array en dengan array id, fr (default id)
		 if($tanggal!=""){
		 return str_replace($en,$$bahasa,date($format,strtotime($tanggal)));
		 }
		 //menampilkan tanggal saat ini
		 //keluaran Tue, 26 Mar 2013
		 //echo date("D, j M Y")."<br/>";
		 
		 //menampilkan tanggal saat ini setelah di konversi
		 //keluaran Minggu, 13 Maret 2011
		 //echo konversi_tanggal("D, j M Y")."<br/>";
		 
		 //menampilkan bulan saat ini
		 //keluaran Maret
		 //echo konversi_tanggal("M")."<br/>";
		 
		 //menampilkan hari saat ini
		 //keluaran Minggu
		 //echo konversi_tanggal("D")."<br/>";
		 
		 //konversi tanggal dari format tanggal di mysql
		 //keluaran Jumat, 17 Agustus 1945
		 //echo konversi_tanggal("D, j M Y","1945-08-17")."<br/>";
		 
		 //konversi tanggal dari format tanggal di mysql
		 //keluaran Jumat
		 //echo konversi_tanggal("D","1945-08-17")."<br/>";
		 
		 //konversi tanggal dari format tanggal di mysql
		 //keluaran Agustus
		 //echo konversi_tanggal("M","1945-08-17")."<br/>";
		 
		 //konversi tanggal dari format dengan bahasa lain
		 //keluaran dimanche, 17 avril 1988
		 //echo konversi_tanggal("D, j M Y","1988-04-17", "fr")."<br/>";
		}
	}
	
	if (!function_exists('snakeToCamel')) {
		function snakeToCamel ($str) {
		  return ucfirst(ucwords(str_replace('_', ' ', $str)));
		}
	}
	if (!function_exists('delkoma')) {
		function delkoma($s){
		  	if($s!=""){
		  		$s=substr($s,0,strlen($s)-1);
			}
			return $s;
		  }
	}
	if (!function_exists('cekjenislapor2')) {
		function cekjenislapor2($s){
			$sts=false;
		  	if($s!=""){
				if(preg_match ("/^([0-9]+)$/", $s)){
					$sts=true;
				}
				if($sts){
					$a=(int)$s;
			  		$sts=($a>0&&$a<=2?true:false);
				}
			}
			return $sts;
		}
	}
	if (!function_exists('cekjenislapor3')) {
		function cekjenislapor3($s){
			$sts=false;
		  	if($s!=""){
				if(preg_match ("/^([0-9]+)$/", $s)){
					$sts=true;
				}
				if($sts){
					$a=(int)$s;
			  		$sts=($a>0&&$a<=3?true:false);
				}
			}
			return $sts;
		}
	}
	if (!function_exists('cekint')) {
		function cekint($s){
			$sts=false;
		  	if($s!=""){
				if(preg_match ("/^([0-9]+)$/", $s)){
					$sts=true;
				}
			}
			return $sts;
		}
	}
	if (!function_exists('cekintnull')) {
		function cekintnull($s){
			$sts=false;
		  	if($s!=""){
				if(preg_match ("/^([0-9]+)$/", $s)){
					$sts=true;
				}
			}
			else{
				$sts=true;
			}
			return $sts;
		}
	}
	if (!function_exists('cekintnulldot')) {
		function cekintnulldot($s){
			$sts=false;
		  	if($s!=""){
				if(preg_match ("/^([0-9.]+)$/", $s)){
					$sts=true;
				}
			}
			else{
				$sts=true;
			}
			return $sts;
		}
	}
	if (!function_exists('repstr')) {
		function repstr($m){
			$s="";
			$banlist = ARRAY (
		           "insert", "select", "update", "delete", "distinct", "having", "truncate", "replace","drop",
		           "like", "procedure", "limit", "order by", "group by", "asc", "desc","script","alert","onclick","from"
		    );
			if($m!=""){
				$s=htmlspecialchars($m);
				$s = trim ( str_ireplace ( $banlist, '',  $s ) );
			}
			return $s;
		}
	}
	if (!function_exists('repstra')) {
		function repstra($m){
			$s="";
			$banlist = ARRAY (
		           "insert", "select", "delete", "distinct", "having", "truncate", "replace","drop",
		           "like", "procedure", "limit", "order by", "group by", "asc", "desc","script","alert","onclick","from"
		    );
			if($m!=""){
				$s=htmlspecialchars($m);
				$s = trim ( str_ireplace ( $banlist, '',  $s ) );
			}
			return $s;
		}
	}
	if (!function_exists('encodeURIComponent')) {
		function encodeURIComponent($s){
			$revert = array('%21'=>'!', '%2A'=>'*', '%27'=>"'", '%28'=>'(', '%29'=>')');
	    	return strtr(rawurlencode($s), $revert);
		}
	}
	if (!function_exists('ec')) {
		function ec($s){
		  	if($s!=""){
				$ciphering = "AES-128-CTR";
				$iv_length = openssl_cipher_iv_length($ciphering);
				$options = 0;
				$encryption_iv = '1234567891011121';
				$encryption_key = "sendalJKT12";
				$s = bin2hex(openssl_encrypt($s, $ciphering, $encryption_key, $options, $encryption_iv));
			}
			return $s;
		}
	}
	if (!function_exists('dc')) {
		function dc($s){
		  	if($s!=""){
				if(!isHex($s)){
					$s='foo';
				}
				else{
					if(strlen($s)>4){
						$ciphering = "AES-128-CTR";
						$options = 0;
						$decryption_iv = '1234567891011121';
						$decryption_key = "sendalJKT12";
						$s = openssl_decrypt(hex2bin($s), $ciphering, $decryption_key, $options, $decryption_iv);
					}
					else{
						$s='foo';
					}
				}
			}
			return $s;
		}
	}
	if (!function_exists('aksi_upload')) {
		function aksi_upload($file,$folder,$nm,$ext){
		  	if($folder!=''&&$nm!=""){
				$nm=($nm!=""?str_replace('/','_',$nm):'');
        		$nm=str_replace('.',',',$nm);
				$file->move('./media/uploads/'.$folder,$nm.'.'.$ext);
			}
			return $nm.'.'.$ext;
		}
	}
	if (!function_exists('isHex')) {
		function isHex(string $str):bool{
		  	return preg_match('/^(?:0x)?[a-f0-9]{1,}$/i', $str);
		}
	}
	if (!function_exists('get_userid_ssobaru')) {
		function get_userid_ssobaru($username){
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.bawaslu.go.id/api/v1/backoffice/sigap/lapor/user/get/username?username=".$username,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_ENCODING => "",
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPHEADER =>[
					'x-api-key: 9016d8eea8d59d8099e6b0c7e1cccdf5c4abb15bb3118d04874b07362703ec90'
				],
			]);
			
			$response = curl_exec($curl);
			//$err = curl_error($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			//var_export($err);
			//die();
			if ($httpCode==200) {
				return $username;
			} else {
				return '';
			}
		}
	}
	if (!function_exists('cek_userid_sso')) {
		function cek_userid_sso($username){
			$token=get_token_sa();
			$userid='';
			if($token!=""){
				$userid=get_userid_sso($token,$username);
			}
			return $userid;
		}
	}
	
	if (!function_exists('reset_password_sso')) {
		function reset_password_sso($username,$password){
			$token=get_token_sa();
			if($token!=""){
				$userid=get_userid_sso($token,$username);
				if($userid!=''){
					$curl = curl_init();
					$payload = json_encode(array(
			            'type' => "password",
			            'value' => $password,
					    'temporary' => false,
					));
					curl_setopt_array($curl, [
						CURLOPT_URL => "https://10.11.12.108:8443/auth/admin/realms/superapp/users/".$userid."/reset-password",
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_FOLLOWLOCATION => true,
						CURLOPT_ENCODING => "",
						CURLOPT_TIMEOUT => 30,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_CUSTOMREQUEST => "PUT",
						CURLOPT_POSTFIELDS => $payload,
						CURLOPT_HTTPHEADER =>[
							"Content-Type: application/json",
							'Authorization: Bearer '.$token
						],
					]);
					
					$response = curl_exec($curl);
					$err = curl_error($curl);
					curl_close($curl);
					if ($err) {
						//echo "Error #:" . $err;
						return '';
					} else {
						return 'success';
					}
				}
				else{
					return '';
				}
			}
			else{
				return '';
			}
		}
	}
	
	if (!function_exists('reset_password_ssobaru')) {
		function reset_password_ssobaru($username,$password){
			$curl = curl_init();
			$payload = array(
	            'username' => $username,
	            'new_password' => $password
			);
			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.bawaslu.go.id/api/v1/backoffice/sigap/lapor/user/reset/password",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_ENCODING => "",
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "PUT",
				CURLOPT_POSTFIELDS => http_build_query($payload),
				CURLOPT_HTTPHEADER =>[
					"x-api-key: 9016d8eea8d59d8099e6b0c7e1cccdf5c4abb15bb3118d04874b07362703ec90"
				],
			]);
			
			$response = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			if ($httpCode==200) {
				return 'success';
			} else {
				//echo "Error #:" . $err;
				return '';
			}
		}
	}
	if (!function_exists('delete_password_sso')) {
		function delete_password_sso($username){
			$token=get_token_sa();
			if($token!=""){
				$userid=get_userid_sso($token,$username);
				if($userid!=''){
					$curl = curl_init();
					curl_setopt_array($curl, [
						CURLOPT_URL => "https://10.11.12.108:8443/auth/admin/realms/superapp/users/".$userid,
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_FOLLOWLOCATION => true,
						CURLOPT_ENCODING => "",
						CURLOPT_TIMEOUT => 30,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_CUSTOMREQUEST => "DELETE",
						CURLOPT_HTTPHEADER =>[
							"Content-Type: application/json",
							'Authorization: Bearer '.$token
						],
					]);
					
					$response = curl_exec($curl);
					$err = curl_error($curl);
					curl_close($curl);
					if ($err) {
						//echo "Error #:" . $err;
						return '';
					} else {
						return 'success';
					}
				}
				else{
					return '';
				}
			}
			else{
				return '';
			}
		}
	}
	if (!function_exists('ssobaru_user_create')) {
		function ssobaru_user_create($username,$password,$name,$email=null){
			$curl = curl_init();
			$payload = array(
	            'name' => $name,
	            'username' => $username,
			    'password' => $password
			);
			//echo $payload;
			//die();
			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.bawaslu.go.id/api/v1/backoffice/sigap/lapor/user/create",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_ENCODING => "",
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_POSTFIELDS => http_build_query($payload),
				CURLOPT_HTTPHEADER =>[
					'x-api-key: 9016d8eea8d59d8099e6b0c7e1cccdf5c4abb15bb3118d04874b07362703ec90'
				],
			]);
			
			$response = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$err = curl_error($curl);
			curl_close($curl);
			//var_export($response);
			//die();
			if ($httpCode==200) {
				return 'success';
			} else {
				//echo "Error #:" . $err;
				return '';
			}
		}
	}
	if (!function_exists('ssobaru_user_update')) {
		function ssobaru_user_update($username,$name,$email=null){
			$curl = curl_init();
			$payload = array(
	            'name' => $name,
	            'username' => $username,
			    'email' => $email
			);
			//echo $payload;
			//die();
			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.bawaslu.go.id/api/v1/backoffice/sigap/lapor/user/update",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_POST => true,
				CURLOPT_ENCODING => "",
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "PUT",
				CURLOPT_POSTFIELDS => http_build_query($payload),
				CURLOPT_HTTPHEADER =>[
					'x-api-key: 9016d8eea8d59d8099e6b0c7e1cccdf5c4abb15bb3118d04874b07362703ec90'
				],
			]);
			
			$response = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$err = curl_error($curl);
			curl_close($curl);
			//var_export($response);
			//die();
			if ($httpCode==200) {
				return 'success';
			} else {
				//echo "Error #:" . $err;
				return '';
			}
		}
	}
	if (!function_exists('ssobaru_user_delete')) {
		function ssobaru_user_delete($username=null){
			$curl = curl_init();
			$payload['username']=$username;
			curl_setopt_array($curl, [
				CURLOPT_URL => "https://api-gateway.bawaslu.go.id/api/v1/backoffice/sigap/lapor/user/delete",
				CURLOPT_POST => true,
				CURLOPT_CUSTOMREQUEST => "DELETE",
				CURLOPT_POSTFIELDS => $payload,
				CURLOPT_HTTPHEADER =>[
					"x-api-key: 9016d8eea8d59d8099e6b0c7e1cccdf5c4abb15bb3118d04874b07362703ec90"
				],
			]);
			
			$response = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			//var_export($response);
			//$err = curl_error($curl);
			if ($httpCode==200) {
				return 'success';
			} else {
				//echo "Error #:" . $err;
				return '';
			}
		}
	}
	if (!function_exists('kirim_email')) {
	    function kirim_email($params = array()) {
			$config = [
	            'mailtype'  => 'html',
	            'charset'   => 'iso-8859-1',
	            'protocol'  => 'mail',
	            'smtp_host' => 'mail.bawaslu.go.id',
	            'smtp_user' => 'sigaplapor@bawaslu.go.id',
	            'smtp_pass'   => 'Sigaplapor#123',
	            'smtp_crypto' => 'ssl',
	            'smtp_port'   => 465,
	            'crlf'    => "\r\n",
	            'newline' => "\r\n"
	        ];
			/**
			$ci = & get_instance();
			$ci->load->library('email', $config);
		    $ci->email->from('sigaplapor@bawaslu.go.id', 'SIGAPLapor Bawaslu');
		    $ci->email->to($params['toemail']);	
		    $ci->email->subject($params['subyek']);
		    $ci->email->message($params['pesan']);
			if($ci->email->send()){
				return true;
			}
			else{
				return false;
			}
			**/
			return true;
	    }
	}
?>